/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.stianloader.micromixin.transform.api.BytecodeProvider;
import org.stianloader.micromixin.transform.api.CodeSourceURIProvider;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.MixinConfig;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.ModularityAttached;
import org.stianloader.micromixin.transform.api.supertypes.ClassWrapperPool;
import org.stianloader.micromixin.transform.internal.DefaultMixinLogger;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.selectors.inject.ConstantInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.FieldInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.HeadInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.InvokeInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.LoadInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.NewInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.ReturnInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.StoreInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.selectors.inject.TailInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.util.Objects;
import org.stianloader.micromixin.transform.internal.util.smap.FileSection;
import org.stianloader.micromixin.transform.internal.util.smap.LineSection;
import org.stianloader.micromixin.transform.internal.util.smap.SMAPRoot;

public class MixinTransformer<M> {
    private static final boolean DEBUG = Boolean.getBoolean("org.stianloader.micromixin.debug");
    @NotNull
    private final BytecodeProvider<M> bytecodeProvider;
    private boolean delayParseExceptions = Boolean.getBoolean("org.stianloader.micromixin.delayedParseException");
    @NotNull
    private final InjectionPointSelectorFactory injectionPointSelectors = new InjectionPointSelectorFactory();
    @NotNull
    private MixinLoggingFacade logger = new DefaultMixinLogger(DEBUG);
    private boolean mergeClassFileVersions = true;
    @NotNull
    private final Map<ModularityAttached<M, String>, ClassNode> mixinNodes = new HashMap<ModularityAttached<M, String>, ClassNode>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinConfig> mixins = new HashMap<ModularityAttached<M, String>, MixinConfig>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinStub> mixinStubs = new HashMap<ModularityAttached<M, String>, MixinStub>();
    @NotNull
    private final Map<String, TreeSet<MixinStub>> mixinTargets = new HashMap<String, TreeSet<MixinStub>>();
    @NotNull
    private final Map<ModularityAttached<M, String>, MixinConfig> packageDeclarations = new HashMap<ModularityAttached<M, String>, MixinConfig>();
    @NotNull
    private final ClassWrapperPool pool;

    public MixinTransformer(@NotNull BytecodeProvider<M> bytecodeProvider, @NotNull ClassWrapperPool pool) {
        this.bytecodeProvider = bytecodeProvider;
        this.pool = pool;
        this.injectionPointSelectors.register(ConstantInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(HeadInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(InvokeInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(ReturnInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(TailInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(FieldInjectionPointSelector.PROVIDER);
        this.injectionPointSelectors.register(LoadInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(StoreInjectionPointSelector.INSTANCE);
        this.injectionPointSelectors.register(NewInjectionPointSelector.PROVIDER);
    }

    public void addMixin(M attachment, @NotNull MixinConfig config) {
        Objects.requireNonNull(config, "config must not be null");
        if (this.isMixin(attachment, config.mixinPackage)) {
            throw new IllegalStateException("Two mixin configurations within the same modularity attachment (" + attachment + ") target the same package (" + config.mixinPackage + ").");
        }
        this.packageDeclarations.put(new ModularityAttached<M, String>(attachment, config.mixinPackage), config);
        this.getLogger().debug(MixinTransformer.class, "Registering mixin package {} under modularity attachment {}", config.mixinPackage, attachment);
        StringBuilder sharedBuilder = new StringBuilder();
        for (String mixin : config.mixins) {
            ModularityAttached<M, String> mixinRef = new ModularityAttached<M, String>(attachment, config.mixinPackage + "/" + mixin);
            if (this.mixins.containsKey(mixinRef)) {
                throw new IllegalStateException("Two mixin configurations within the same modularity attachment (" + attachment + ") use the same class (" + (String)mixinRef.value + ").");
            }
            this.mixins.put(mixinRef, config);
            try {
                URI uncheckedAssignmentHack;
                ClassNode node = this.bytecodeProvider.getClassNode(attachment, (String)mixinRef.value);
                URI codeSourceURI = this.bytecodeProvider instanceof CodeSourceURIProvider ? (uncheckedAssignmentHack = ((CodeSourceURIProvider)((Object)this.bytecodeProvider)).findURI(attachment, (String)mixinRef.value)) : null;
                MixinStub stub = MixinStub.parse(config.priority, node, this, codeSourceURI, sharedBuilder);
                this.mixinNodes.put(mixinRef, node);
                this.mixinStubs.put(mixinRef, stub);
                HashSet<String> targets = new HashSet<String>();
                for (String desc : stub.header.targets) {
                    if (!targets.add(desc)) continue;
                    TreeSet<MixinStub> val = this.mixinTargets.get(desc);
                    if (val == null) {
                        val = new TreeSet();
                        this.mixinTargets.put(desc, val);
                    }
                    val.add(stub);
                }
                this.getLogger().debug(MixinTransformer.class, "Registering mixin {} under modularity attachment {}, the mixin target following classes: {}. The code source URI of the mixin is {}", mixinRef.value, attachment, targets, codeSourceURI);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Broken mixin: " + (String)mixinRef.value + " (attached via " + attachment + ")", e);
            }
            catch (MixinParseException e) {
                throw new IllegalStateException("Broken mixin: " + (String)mixinRef.value + " (attached via " + attachment + ")", e);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    public InjectionPointSelectorFactory getInjectionPointSelectors() {
        return this.injectionPointSelectors;
    }

    @NotNull
    public MixinLoggingFacade getLogger() {
        return this.logger;
    }

    @NotNull
    public ClassWrapperPool getPool() {
        return this.pool;
    }

    public boolean isDelayingParseExceptions() {
        return this.delayParseExceptions;
    }

    public boolean isMergingClassFileVersions() {
        return this.mergeClassFileVersions;
    }

    public boolean isMixin(M attachment, @NotNull String internalName) {
        ModularityAttached<M, String> attached = new ModularityAttached<M, String>(attachment, internalName);
        if (this.packageDeclarations.containsKey(attached)) {
            return true;
        }
        int slashIndex = internalName.lastIndexOf(47);
        if (slashIndex == -1) {
            return false;
        }
        return this.isMixin(attachment, internalName.substring(0, slashIndex));
    }

    public boolean isMixinTarget(@NotNull String name) {
        return this.mixinTargets.containsKey(name);
    }

    public void setDelayParseExceptions(boolean delayParseExceptions) {
        this.delayParseExceptions = delayParseExceptions;
    }

    public void setLogger(@NotNull MixinLoggingFacade logger) {
        this.logger = logger;
    }

    public void setMergeClassFileVersions(boolean mergeClassFileVersions) {
        this.mergeClassFileVersions = mergeClassFileVersions;
    }

    @Deprecated
    @ApiStatus.Obsolete
    public void transform(@NotNull ClassNode in) {
        this.transform(in, null);
    }

    @ApiStatus.AvailableSince(value="0.7.0-a20241008")
    public void transform(@NotNull ClassNode in, @Nullable URI classCodeSourceURI) {
        Iterable mixins = this.mixinTargets.get(in.name);
        if (mixins == null) {
            return;
        }
        this.getLogger().debug(MixinTransformer.class, "Transforming class {} using following stubs: {}", in.name, mixins);
        HandlerContextHelper hctx = HandlerContextHelper.from(in);
        StringBuilder sharedBuilder = new StringBuilder();
        for (MixinStub stub : mixins) {
            boolean previewSource;
            boolean previewOrigin;
            try {
                this.getLogger().debug(MixinTransformer.class, "Applying mixin {} to transforming classnode {}.", stub.sourceNode.name, in.name);
                stub.applyTo(in, hctx, sharedBuilder);
            }
            catch (Throwable t) {
                if (t instanceof Error && !(t instanceof AssertionError)) {
                    throw (Error)t;
                }
                if (DEBUG) {
                    StringWriter sw = new StringWriter();
                    TraceClassVisitor tcv = new TraceClassVisitor(null, new Textifier(), new PrintWriter(sw));
                    in.accept(tcv);
                    this.getLogger().info(MixinTransformer.class, "Disassembled class file:\n{}", sw);
                }
                throw new RuntimeException("Failed to apply mixin stub originating from " + stub.sourceNode.name + " to node " + in.name, t);
            }
            if (!this.isMergingClassFileVersions()) continue;
            int adjustOrigin = in.version & 0xFFFF;
            int adjustSource = stub.sourceNode.version & 0xFFFF;
            if (adjustOrigin < adjustSource) {
                in.version = stub.sourceNode.version;
                continue;
            }
            if (adjustOrigin != adjustSource || !((previewOrigin = (in.version & 0xFFFF0000) == -65536) | (previewSource = (stub.sourceNode.version & 0xFFFF0000) == -65536))) continue;
            in.version |= 0xFFFF0000;
        }
        SMAPRoot smap = hctx.lineAllocator.exportToSMAP("Mixin");
        if (this.bytecodeProvider instanceof CodeSourceURIProvider) {
            ArrayList<FileSection.FileSectionEntry> fileSectionEntries = new ArrayList<FileSection.FileSectionEntry>();
            int sourceId = classCodeSourceURI == null ? 1 : 2;
            int sourceOffset = sourceId - 1;
            for (MixinStub stub : mixins) {
                URI codeSourceURI = stub.codeSourceURI;
                if (codeSourceURI == null) continue;
                try {
                    String path = Objects.requireNonNull(codeSourceURI.toURL().toExternalForm());
                    fileSectionEntries.add(new FileSection.FileSectionEntry(++sourceId, path, null));
                }
                catch (MalformedURLException e) {
                    this.logger.warn(MixinTransformer.class, "Cannot convert URI to external form: '{}'", codeSourceURI, e);
                }
            }
            if (!fileSectionEntries.isEmpty()) {
                String sourceName = in.sourceFile;
                if (sourceName == null) {
                    sourceName = "sourceFile";
                }
                if (classCodeSourceURI != null) {
                    try {
                        fileSectionEntries.add(0, new FileSection.FileSectionEntry(2, Objects.requireNonNull(classCodeSourceURI.toURL().toExternalForm()), null));
                    }
                    catch (MalformedURLException e) {
                        fileSectionEntries.add(0, new FileSection.FileSectionEntry(2, classCodeSourceURI.toString(), null));
                    }
                    fileSectionEntries.add(0, new FileSection.FileSectionEntry(1, sourceName, null));
                } else {
                    fileSectionEntries.add(0, new FileSection.FileSectionEntry(1, sourceName, null));
                }
                ArrayList<LineSection.LineInfo> lineSectionEntries = new ArrayList<LineSection.LineInfo>();
                LineSection jdtLineSection = new LineSection(lineSectionEntries);
                LineSection mixinLineSection = smap.getLineSection("Mixin");
                if (mixinLineSection != null) {
                    for (LineSection.LineInfo mixinLineInfo : mixinLineSection.getLineInfos()) {
                        LineSection.LineInfo jdtLineInfo = new LineSection.LineInfo(mixinLineInfo.inputStartLine, mixinLineInfo.lineFileId + sourceOffset, mixinLineInfo.inputLineCount, mixinLineInfo.outputLineIncrement, mixinLineInfo.outputStartLine);
                        lineSectionEntries.add(jdtLineInfo);
                    }
                }
                smap.appendStratum("jdt", new FileSection(fileSectionEntries), jdtLineSection, "org.stianloader.micromixin.transform");
            }
        }
        smap.applyTo(in, sharedBuilder, this.getLogger());
        if (DEBUG) {
            try {
                CheckClassAdapter cca = new CheckClassAdapter(null);
                in.accept(cca);
            }
            catch (Throwable t) {
                this.getLogger().error(MixinTransformer.class, "Invalidly transformed class: {}", in.name, t);
                StringWriter sw = new StringWriter();
                TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(sw));
                in.accept(tcv);
                this.getLogger().info(MixinTransformer.class, "Disassembled class file:\n", sw);
            }
        }
    }
}

