/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.stianloader.picoresolve.internal.MultiCompletableFuture;

public class StronglyMultiCompletableFuture<T>
extends CompletableFuture<List<T>> {
    private final CompletableFuture<T>[] sources;
    private final T[] results;
    private final Throwable[] exceptions;
    private final AtomicInteger completions = new AtomicInteger();
    private int exceptionally = 0;

    public StronglyMultiCompletableFuture(List<CompletableFuture<T>> sources) {
        this(sources.toArray(new CompletableFuture[0]));
    }

    @SafeVarargs
    public StronglyMultiCompletableFuture(CompletableFuture<T> ... sources) {
        this.sources = sources;
        this.exceptions = new Throwable[this.sources.length];
        this.results = new Object[this.sources.length];
        int i = 0;
        while (i < sources.length) {
            CompletableFuture<T> future = sources[i];
            int futureIndex = i++;
            future.thenAccept(res -> this.sourceCompleted(futureIndex, res));
            future.exceptionally((T ex) -> {
                this.sourceException(futureIndex, (Throwable)ex);
                return null;
            });
        }
        if (sources.length == 0) {
            this.complete(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceCompleted(int i, T result) {
        Objects.requireNonNull(result);
        StronglyMultiCompletableFuture stronglyMultiCompletableFuture = this;
        synchronized (stronglyMultiCompletableFuture) {
            if (this.exceptions[i] != null || this.results[i] != null) {
                return;
            }
            this.results[i] = result;
            if (this.completions.incrementAndGet() == this.results.length && !this.isDone()) {
                ArrayList<T> results = new ArrayList<T>();
                for (T t : this.results) {
                    if (t == null) continue;
                    results.add(t);
                }
                this.complete(results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceException(int i, Throwable exception) {
        Objects.requireNonNull(exception);
        StronglyMultiCompletableFuture stronglyMultiCompletableFuture = this;
        synchronized (stronglyMultiCompletableFuture) {
            if (this.exceptions[i] != null || this.results[i] != null) {
                return;
            }
            this.exceptions[i] = exception;
            if (++this.exceptionally == this.exceptions.length && !this.isDone()) {
                this.completeExceptionally(this.generateException().fillInStackTrace());
            }
            if (this.completions.incrementAndGet() == this.results.length && !this.isDone()) {
                ArrayList<T> results = new ArrayList<T>();
                for (T t : this.results) {
                    if (t == null) continue;
                    results.add(t);
                }
                this.complete(results);
            }
        }
    }

    protected CompletionException generateException() {
        return new MultiCompletableFuture.MultiCompletionException(this.exceptions);
    }

    public final void throwExceptionIfCompletedUncleanly() {
        if (this.exceptionally == 0) {
            return;
        }
        throw this.generateException();
    }
}

