/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.utils.mappings;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.mappings.MapRemapper;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.FieldRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

@ParametersAreNonnullByDefault
public class Remapper {
    public static MethodNode remapAndAdd(ClassNode source, ClassNode target, MethodNode methodNode) {
        return Remapper.remapAndAdd(source.name, target.name, target, methodNode);
    }

    public static FieldNode remapAndAdd(ClassNode source, ClassNode target, FieldNode fieldNode) {
        return Remapper.remapAndAdd(source.name, target.name, target, fieldNode);
    }

    public static MethodNode remapAndAdd(String sourceName, String targetName, ClassNode holder, MethodNode methodNode) {
        MapRemapper remapper = new MapRemapper(sourceName, targetName);
        MethodNode newNode = new MethodNode(methodNode.access, remapper.mapMethodName(sourceName, methodNode.name, methodNode.desc), remapper.mapDesc(methodNode.desc), methodNode.signature, methodNode.exceptions == null ? null : remapper.mapTypes(methodNode.exceptions.toArray(new String[0])));
        MethodRemapper methodRemapper = new MethodRemapper(newNode, remapper);
        methodNode.accept(methodRemapper);
        holder.methods.add(newNode);
        return newNode;
    }

    public static FieldNode remapAndAdd(String sourceName, String targetName, ClassNode holder, FieldNode fieldNode) {
        MapRemapper remapper = new MapRemapper(sourceName, targetName);
        FieldNode newNode = new FieldNode(fieldNode.access, remapper.mapFieldName(sourceName, fieldNode.name, fieldNode.desc), remapper.mapDesc(fieldNode.desc), remapper.mapSignature(fieldNode.signature, true), fieldNode.value == null ? null : remapper.mapValue(fieldNode.value));
        FieldRemapper fieldRemapper = new FieldRemapper(newNode, remapper);
        if (fieldNode.visibleTypeAnnotations != null) {
            for (TypeAnnotationNode typeAnnotationNode : fieldNode.visibleTypeAnnotations) {
                typeAnnotationNode.accept(fieldRemapper.visitTypeAnnotation(typeAnnotationNode.typeRef, typeAnnotationNode.typePath, typeAnnotationNode.desc, true));
            }
        }
        if (fieldNode.invisibleTypeAnnotations != null) {
            for (TypeAnnotationNode typeAnnotationNode : fieldNode.invisibleTypeAnnotations) {
                typeAnnotationNode.accept(fieldRemapper.visitTypeAnnotation(typeAnnotationNode.typeRef, typeAnnotationNode.typePath, typeAnnotationNode.desc, false));
            }
        }
        if (fieldNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.visibleAnnotations) {
                annotationNode.accept(fieldRemapper.visitAnnotation(annotationNode.desc, true));
            }
        }
        if (fieldNode.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.invisibleAnnotations) {
                annotationNode.accept(fieldRemapper.visitAnnotation(annotationNode.desc, false));
            }
        }
        holder.fields.add(newNode);
        return newNode;
    }

    public static ClassNode remap(String sourceName, String targetName, ClassNode node) {
        return Remapper.remap(node, new MapRemapper(sourceName, targetName));
    }

    public static ClassNode remap(ClassNode node, MapRemapper remapper) {
        ClassNode remappedNode = new ClassNode();
        ClassRemapper classRemapper = new ClassRemapper(remappedNode, remapper);
        node.accept(classRemapper);
        return remappedNode;
    }

    public static void merge(ClassNode original, ClassNode toMerge) {
        for (Field field : ClassNode.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                field.set(original, field.get(toMerge));
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to merge class nodes", t);
            }
        }
    }
}

