/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.annotations.injection.CRecordComponent;
import net.lenni0451.classtransform.exceptions.TransformerException;
import net.lenni0451.classtransform.transformer.AnnotationHandler;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.Types;
import net.lenni0451.classtransform.utils.mappings.Remapper;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;

@ParametersAreNonnullByDefault
public class CRecordComponentAnnotationHandler
extends AnnotationHandler {
    private static final String OBJECTMETHODS_BOOTSTRAP_DESC = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/TypeDescriptor;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;";

    @Override
    public void transform(TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer) {
        ArrayList<FieldNode> recordComponents = new ArrayList<FieldNode>();
        ArrayList<FieldNode> constructor = new ArrayList<FieldNode>();
        ArrayList<FieldNode> getter = new ArrayList<FieldNode>();
        ArrayList<FieldNode> toString = new ArrayList<FieldNode>();
        ArrayList<FieldNode> equals = new ArrayList<FieldNode>();
        ArrayList<FieldNode> hashCode = new ArrayList<FieldNode>();
        Iterator<FieldNode> it = transformer.fields.iterator();
        while (it.hasNext()) {
            FieldNode field = it.next();
            CRecordComponent recordComponent = this.getAnnotation(CRecordComponent.class, field, transformerManager);
            if (recordComponent == null) continue;
            this.copyField(transformer, transformedClass, field);
            it.remove();
            if (recordComponent.addRecordComponent()) {
                recordComponents.add(field);
            }
            if (recordComponent.addConstructor()) {
                constructor.add(field);
            }
            if (recordComponent.addGetter()) {
                getter.add(field);
            }
            if (recordComponent.addToString()) {
                toString.add(field);
            }
            if (recordComponent.addEquals()) {
                equals.add(field);
            }
            if (!recordComponent.addHashCode()) continue;
            hashCode.add(field);
        }
        if (!recordComponents.isEmpty()) {
            this.addRecordComponents(transformedClass, recordComponents);
        }
        if (!constructor.isEmpty()) {
            this.addConstructor(transformer, transformedClass, constructor);
        }
        if (!getter.isEmpty()) {
            this.addGetter(transformer, transformedClass, getter);
        }
        if (!toString.isEmpty()) {
            this.addToString(transformedClass, toString);
        }
        if (!equals.isEmpty()) {
            this.addEquals(transformedClass, equals);
        }
        if (!hashCode.isEmpty()) {
            this.addHashCode(transformedClass, hashCode);
        }
    }

    private void copyField(ClassNode transformer, ClassNode transformedClass, FieldNode field) {
        if (ASMUtils.hasField(transformedClass, field.name, field.desc)) {
            throw TransformerException.alreadyExists(field, transformer, transformedClass);
        }
        this.prepareForCopy(transformer, field);
        Remapper.remapAndAdd(transformer, transformedClass, field);
    }

    private void addRecordComponents(ClassNode transformedClass, List<FieldNode> fields) {
        if (transformedClass.recordComponents == null) {
            transformedClass.recordComponents = new ArrayList<RecordComponentNode>();
        }
        for (FieldNode field : fields) {
            transformedClass.recordComponents.add(new RecordComponentNode(field.name, field.desc, field.signature));
        }
    }

    private void addConstructor(ClassNode transformer, ClassNode transformedClass, List<FieldNode> fields) {
        Type type;
        List<RecordComponentNode> oldRecordComponents = transformedClass.recordComponents.subList(0, transformedClass.recordComponents.size() - fields.size());
        List<RecordComponentNode> newRecordComponents = transformedClass.recordComponents;
        String mainDescriptor = Types.methodDescriptor(Void.TYPE, oldRecordComponents.stream().map(comp -> comp.descriptor).toArray(Object[]::new));
        String newDescriptor = Types.methodDescriptor(Void.TYPE, newRecordComponents.stream().map(comp -> comp.descriptor).toArray(Object[]::new));
        MethodNode constructor = new MethodNode(1, "<init>", newDescriptor, null, null);
        if (ASMUtils.hasMethod(transformedClass, constructor.name, constructor.desc)) {
            throw TransformerException.alreadyExists(constructor, transformer, transformedClass);
        }
        constructor.visitVarInsn(25, 0);
        int varIndex = 1;
        for (RecordComponentNode component : oldRecordComponents) {
            type = Types.type(component.descriptor);
            constructor.visitVarInsn(type.getOpcode(21), varIndex);
            varIndex += type.getSize();
        }
        constructor.visitMethodInsn(183, transformedClass.name, "<init>", mainDescriptor, false);
        for (FieldNode field : fields) {
            type = Types.type(field.desc);
            constructor.visitVarInsn(25, 0);
            constructor.visitVarInsn(type.getOpcode(21), varIndex);
            constructor.visitFieldInsn(181, transformedClass.name, field.name, field.desc);
            varIndex += type.getSize();
        }
        constructor.visitInsn(177);
        transformedClass.methods.add(constructor);
    }

    private void addGetter(ClassNode transformer, ClassNode transformedClass, List<FieldNode> fields) {
        for (FieldNode field : fields) {
            Type type = Types.type(field.desc);
            MethodNode getter = new MethodNode(1, field.name, "()" + field.desc, null, null);
            if (ASMUtils.hasField(transformedClass, field.name, "()" + field.desc)) {
                throw TransformerException.alreadyExists(getter, transformer, transformedClass);
            }
            getter.visitVarInsn(25, 0);
            getter.visitFieldInsn(180, transformedClass.name, field.name, field.desc);
            getter.visitInsn(type.getOpcode(172));
            transformedClass.methods.add(getter);
        }
    }

    private void addToString(ClassNode transformedClass, List<FieldNode> fields) {
        this.addFieldsToDefaults(transformedClass, fields, "toString", "()Ljava/lang/String;");
    }

    private void addHashCode(ClassNode transformedClass, List<FieldNode> fields) {
        this.addFieldsToDefaults(transformedClass, fields, "hashCode", "()I");
    }

    private void addEquals(ClassNode transformedClass, List<FieldNode> fields) {
        this.addFieldsToDefaults(transformedClass, fields, "equals", "(Ljava/lang/Object;)Z");
    }

    private InvokeDynamicInsnNode getDefaultMethod(ClassNode node, String name, String descriptor) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name) || !method.desc.equals(descriptor)) continue;
            for (AbstractInsnNode instruction : method.instructions) {
                if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)instruction;
                if (!invokeDynamic.bsm.getOwner().equals("java/lang/runtime/ObjectMethods") || !invokeDynamic.bsm.getName().equals("bootstrap") || !invokeDynamic.bsm.getDesc().equals(OBJECTMETHODS_BOOTSTRAP_DESC)) continue;
                return invokeDynamic;
            }
        }
        return null;
    }

    private void addFieldsToDefaults(ClassNode transformedClass, List<FieldNode> fields, String name, String descriptor) {
        InvokeDynamicInsnNode invokeDynamic = this.getDefaultMethod(transformedClass, name, descriptor);
        if (invokeDynamic == null) {
            return;
        }
        Object[] newArgs = new Object[invokeDynamic.bsmArgs.length + fields.size()];
        System.arraycopy(invokeDynamic.bsmArgs, 0, newArgs, 0, invokeDynamic.bsmArgs.length);
        for (int i = 0; i < fields.size(); ++i) {
            FieldNode field = fields.get(i);
            Handle handle = new Handle(1, transformedClass.name, field.name, field.desc, Modifier.isInterface(transformedClass.access));
            newArgs[invokeDynamic.bsmArgs.length + i] = handle;
            String fieldNames = (String)newArgs[1];
            newArgs[1] = fieldNames + (fieldNames.isEmpty() ? "" : ";") + field.name;
        }
        invokeDynamic.bsmArgs = newArgs;
    }
}

