/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minestom.server.extras.selfmodification.HierarchyClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaInterop {
    @NotNull
    public static final String getClassloaderName(ClassLoader loader) {
        if (loader instanceof HierarchyClassLoader) {
            return ((HierarchyClassLoader)loader).getName();
        }
        return loader.toString();
    }

    @Nullable
    @ApiStatus.AvailableSince(value="4.0.0-a20250906")
    public static final ClassLoader getPlatformClassLoader() {
        return null;
    }

    public static final boolean isJava9() {
        return false;
    }

    public static final byte @NotNull [] readAllBytes(@NotNull InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = in.read(buffer);
        while (read != -1) {
            baos.write(buffer, 0, read);
            read = in.read(buffer);
        }
        return baos.toByteArray();
    }
}

