/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.interjava;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.stianloader.interjava.CachingClassNodeLookup;
import org.stianloader.interjava.supertypes.ASMClassWrapperProvider;
import org.stianloader.interjava.supertypes.ClassWrapper;
import org.stianloader.interjava.supertypes.ClassWrapperPool;
import org.stianloader.interjava.supertypes.J8CWPComputingClassWriter;
import org.stianloader.interjava.supertypes.ReflectionClassWrapperProvider;
import xyz.wagyourtail.jvmdg.ClassDowngrader;
import xyz.wagyourtail.jvmdg.version.VersionProvider;

public abstract class DowngradedArchiveTask
extends AbstractArchiveTask {
    @Input
    public abstract Property<Boolean> getIncludeExtraClasses();

    @Input
    public abstract Property<Integer> getTargetBytecodeVersion();

    @InputFiles
    public abstract ConfigurableFileCollection getCompileClassPath();

    public DowngradedArchiveTask() {
        this.getIncludeExtraClasses().convention((Object)true);
        this.getTargetBytecodeVersion().convention((Object)51);
        this.getArchiveClassifier().convention(this.getProject().getProviders().provider(() -> {
            if ((Integer)this.getTargetBytecodeVersion().get() == 196653) {
                return "j1";
            }
            if ((Integer)this.getTargetBytecodeVersion().get() < 0) {
                return "downgraded";
            }
            return "j" + ((Integer)this.getTargetBytecodeVersion().get() - 44);
        }));
        this.getArchiveExtension().convention((Object)"jar");
        this.getDestinationDirectory().set(this.getProject().getLayout().getBuildDirectory().dir("libs"));
    }

    protected CopyAction createCopyAction() {
        return caps -> {
            Class<?> runtimeClass;
            LinkedHashMap fileDetails = new LinkedHashMap();
            HashMap<String, byte[]> rawData = new HashMap<String, byte[]>();
            HashSet<String> directories = new HashSet<String>();
            AtomicBoolean doneProcessing = new AtomicBoolean();
            caps.process(file -> {
                if (doneProcessing.get()) {
                    throw new IllegalStateException("processFile called after the process call. This hints towards synchronization issues");
                }
                if (fileDetails.putIfAbsent(file.getRelativePath().getPathString(), file) != null) {
                    throw new IllegalStateException("Duplicate entry: '" + file.getRelativePath().getPathString() + "' (Note: duplicate file handling strategies are not yet implemented)");
                }
                if (!file.isDirectory()) {
                    long len = file.getSize();
                    ByteArrayOutputStream baos = len <= 0L || len > 0x10000000L ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)len);
                    file.copyTo((OutputStream)baos);
                    rawData.put(file.getRelativePath().getPathString(), baos.toByteArray());
                }
                for (RelativePath ownerDir = file.getRelativePath().getParent(); ownerDir != null && directories.add(ownerDir.getPathString()); ownerDir = ownerDir.getParent()) {
                }
            });
            doneProcessing.set(true);
            final CachingClassNodeLookup nodeLookup = new CachingClassNodeLookup(rawData);
            try {
                runtimeClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("xyz.wagyourtail.jvmdg.exc.MissingStubError");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to obtain the URL of the jvmdowngrader-java-api jar. Is the dependency correctly set on the classpath?", e);
            }
            URL sourceURL = runtimeClass.getProtectionDomain().getCodeSource().getLocation();
            System.setProperty("jvmdg.java-api", sourceURL.getPath());
            ClassDowngrader downgrader = ClassDowngrader.downgradeTo((int)((Integer)this.getTargetBytecodeVersion().get()));
            downgrader.getVersionProviderFor(((Integer)this.getTargetBytecodeVersion().get()).intValue());
            HashSet extra = new HashSet();
            ClassWrapperPool wrapperPool = new ClassWrapperPool();
            wrapperPool.addProvider(new ASMClassWrapperProvider(){

                @Override
                @Nullable
                public ClassNode getNode(@NotNull String name) {
                    return nodeLookup.apply(name);
                }
            });
            HashMap<String, ClassWrapper> compileClasspathWrappers = new HashMap<String, ClassWrapper>();
            for (File f : this.getCompileClassPath().getFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".class") || f.getName().endsWith("module-info.class") || f.getPath().contains("META-INF/versions/")) continue;
                try {
                    InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
                    try {
                        boolean isItf;
                        String[] interfaces;
                        String superName;
                        ClassWrapper wrapper;
                        ClassReader reader = new ClassReader(is);
                        String name2 = reader.getClassName();
                        if (compileClasspathWrappers.putIfAbsent(name2, wrapper = new ClassWrapper(name2, superName = reader.getSuperName(), interfaces = reader.getInterfaces(), isItf = (reader.getAccess() & 0x200) != 0, wrapperPool)) == null) continue;
                        this.getLogger().warn("Duplicate class '{}' on provided compile-time classpath (one of them is provided by '{}').", (Object)name2, (Object)f.getPath());
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception e) {
                    this.getLogger().warn("Unexpected exception raised while analyzing compile classpath");
                }
            }
            wrapperPool.addProvider((name, pool) -> (ClassWrapper)compileClasspathWrappers.get(name));
            wrapperPool.addProvider(new ReflectionClassWrapperProvider(ClassLoader.getSystemClassLoader()));
            try (OutputStream rawOut = Files.newOutputStream(((RegularFile)this.getArchiveFile().get()).getAsFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 ZipOutputStream zipOut = new ZipOutputStream(rawOut);){
                for (Map.Entry fileMapEntry : fileDetails.entrySet()) {
                    byte[] result;
                    ZipEntry entry;
                    String path = (String)fileMapEntry.getKey();
                    FileCopyDetailsInternal file2 = (FileCopyDetailsInternal)fileMapEntry.getValue();
                    if (file2.isDirectory() && (file2.isIncludeEmptyDirs() || directories.contains(path))) {
                        entry = new ZipEntry(path + "/");
                        zipOut.putNextEntry(entry);
                        zipOut.closeEntry();
                        continue;
                    }
                    entry = new ZipEntry(path);
                    zipOut.putNextEntry(entry);
                    if (!path.endsWith(".class") || path.contains("META-INF/versions/")) {
                        zipOut.write((byte[])rawData.get(path));
                        zipOut.closeEntry();
                        continue;
                    }
                    try {
                        String className = path.substring(0, path.length() - 6);
                        ClassNode node = nodeLookup.apply(className);
                        for (VersionProvider downgradeProvider : downgrader.versionProviders(node.version)) {
                            downgradeProvider.downgrade(node, extra, true, nodeLookup::apply);
                        }
                        J8CWPComputingClassWriter writer = new J8CWPComputingClassWriter(wrapperPool, 2);
                        node.accept((ClassVisitor)writer);
                        result = writer.toByteArray();
                    }
                    catch (Throwable e2) {
                        throw new RuntimeException("Failed to transform '" + path + "'", e2);
                    }
                    zipOut.write(result);
                    zipOut.closeEntry();
                }
                if (((Boolean)this.getIncludeExtraClasses().get()).booleanValue()) {
                    if (extra.isEmpty()) {
                        this.getLogger().info("Including no extra classes.");
                    } else {
                        this.getLogger().warn("Extra classes is a rarely used function - there may be dragons.");
                        TreeSet<ClassNode> extraNodes = new TreeSet<ClassNode>((n1, n2) -> n1.name.compareTo(n2.name));
                        for (ClassNode extraNode : extra) {
                            this.getLogger().info("Including extra class {}", (Object)extraNode.name);
                            if (extraNodes.add(extraNode)) continue;
                            this.getLogger().warn("Ignoring duplicate extra classnode '{}'", (Object)extraNode.name);
                        }
                        for (ClassNode extraNode : extraNodes) {
                            String classPath = extraNode.name + ".class";
                            Path dest = Paths.get(classPath, new String[0]);
                            Queue<String> directoryQueue = Collections.asLifoQueue(new ArrayDeque());
                            for (Path directory = dest.getParent(); directory != null && !directories.contains(directory.toString()); directory = directory.getParent()) {
                                directoryQueue.add(directory.toString());
                                directories.add(directory.toString());
                            }
                            while (!directoryQueue.isEmpty()) {
                                ZipEntry entry = new ZipEntry((String)directoryQueue.poll() + "/");
                                zipOut.putNextEntry(entry);
                                zipOut.closeEntry();
                            }
                            zipOut.putNextEntry(new ZipEntry(classPath));
                            J8CWPComputingClassWriter writer = new J8CWPComputingClassWriter(wrapperPool, 2);
                            extraNode.accept((ClassVisitor)writer);
                            zipOut.write(writer.toByteArray());
                            zipOut.closeEntry();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return WorkResults.didWork((boolean)true);
        };
    }

    public void setTargetVersion(JavaVersion version) {
        this.setTargetVersion(version.ordinal() - JavaVersion.VERSION_1_1.ordinal() + 1);
    }

    public void setTargetVersion(int version) {
        if (version < 2) {
            if (version <= 0) {
                throw new IllegalStateException("Unsupported version: " + version);
            }
            this.getTargetBytecodeVersion().set((Object)196653);
        }
        this.getTargetBytecodeVersion().set((Object)(version + 44));
    }
}

