/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.interjava;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.LoggerFactory;

final class CachingClassNodeLookup
implements Function<String, ClassNode> {
    @NotNull
    private final Map<String, byte[]> rawData;
    private final Cache<String, ClassNode> classnodeCache = Caffeine.newBuilder().maximumSize(64L).build();

    public CachingClassNodeLookup(@NotNull Map<String, byte[]> rawData) {
        this.rawData = rawData;
    }

    @Override
    public ClassNode apply(String t) {
        if (t.codePointAt(0) == 91) {
            LoggerFactory.getLogger(CachingClassNodeLookup.class).warn("Attempted to query ClassNode of array type '{}'. Consider it a bug.", (Object)t);
            return null;
        }
        if (t.indexOf(46) >= 0) {
            throw new IllegalStateException("input string expected to be a name of a class as an internal name, but instead got '" + t + "'");
        }
        ClassNode node = (ClassNode)this.classnodeCache.getIfPresent((Object)t);
        if (node != null) {
            return node;
        }
        byte[] data = this.rawData.get(t + ".class");
        if (data == null) {
            return null;
        }
        ClassReader reader = new ClassReader(data);
        node = new ClassNode();
        reader.accept((ClassVisitor)node, 4);
        this.classnodeCache.put((Object)t, (Object)node);
        return node;
    }
}

