/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.jetbrains.annotations.NotNull;

public class MappingIOMappingProvider
implements IMappingProvider {
    @NotNull
    private final MappingTreeView mappingIOTree;
    private final int srcNamespace;
    private final int dstNamespace;

    public MappingIOMappingProvider(@NotNull MappingTreeView mappingIOTree, int srcNamespace, int dstNamespace) {
        this.mappingIOTree = mappingIOTree;
        this.srcNamespace = srcNamespace;
        this.dstNamespace = dstNamespace;
        if (this.srcNamespace == this.dstNamespace) {
            throw new IllegalArgumentException("srcNamespace == dstNamespace: " + srcNamespace + ", " + dstNamespace);
        }
    }

    public void load(IMappingProvider.MappingAcceptor out) {
        for (MappingTreeView.ClassMappingView classView : this.mappingIOTree.getClasses()) {
            IMappingProvider.Member srcMember;
            if (classView == null) {
                throw new NullPointerException();
            }
            String srcClassName = classView.getName(this.srcNamespace);
            out.acceptClass(srcClassName, classView.getName(this.dstNamespace));
            for (MappingTreeView.FieldMappingView fieldView : classView.getFields()) {
                if (fieldView == null) {
                    throw new NullPointerException();
                }
                srcMember = new IMappingProvider.Member(srcClassName, fieldView.getName(this.srcNamespace), fieldView.getDesc(this.srcNamespace));
                out.acceptField(srcMember, fieldView.getName(this.dstNamespace));
            }
            for (MappingTreeView.MethodMappingView methodView : classView.getMethods()) {
                if (methodView == null) {
                    throw new NullPointerException();
                }
                srcMember = new IMappingProvider.Member(srcClassName, methodView.getName(this.srcNamespace), methodView.getDesc(this.srcNamespace));
                out.acceptMethod(srcMember, methodView.getName(this.dstNamespace));
                for (MappingTreeView.MethodArgMappingView argView : methodView.getArgs()) {
                    if (argView == null) {
                        throw new NullPointerException();
                    }
                    out.acceptMethodArg(srcMember, argView.getLvIndex(), argView.getName(this.dstNamespace));
                }
                for (MappingTreeView.MethodVarMappingView lvView : methodView.getVars()) {
                    if (lvView == null) {
                        throw new NullPointerException();
                    }
                    out.acceptMethodVar(srcMember, lvView.getLvIndex(), lvView.getStartOpIdx(), lvView.getLvtRowIndex(), lvView.getName(this.dstNamespace));
                }
            }
        }
    }
}

