/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import kala.compress.archivers.tar.TarArchiveEntry;
import kala.compress.archivers.tar.TarArchiveInputStream;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

public class MIOContainerFormat {
    @NotNull
    public final MappingContainer containerFormat;
    @NotNull
    public final MappingFormat coreFormat;

    public MIOContainerFormat(@NotNull MappingFormat coreFormat, @NotNull MappingContainer containerFormat) {
        this.coreFormat = coreFormat;
        this.containerFormat = containerFormat;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MIOContainerFormat) {
            MIOContainerFormat other = (MIOContainerFormat)obj;
            return this.containerFormat == other.containerFormat && this.coreFormat == other.coreFormat;
        }
        return false;
    }

    public int hashCode() {
        return this.containerFormat.hashCode() ^ this.coreFormat.hashCode();
    }

    public void read(@NotNull Path path, @NotNull MappingVisitor visitor) throws IOException {
        this.containerFormat.read(this.coreFormat, path, visitor);
    }

    public String toString() {
        return "MIOContainerFormat[core = " + String.valueOf(this.coreFormat) + ", container = " + String.valueOf((Object)this.containerFormat) + "]";
    }

    public static enum MappingContainer {
        PLAIN{

            @Override
            public void read(@NotNull MappingFormat format, @NotNull Path path, @NotNull MappingVisitor visitor) throws IOException {
                MappingReader.read((Path)path, (MappingFormat)format, (MappingVisitor)visitor);
            }
        }
        ,
        TAR_XZ{

            @Override
            public void read(@NotNull MappingFormat format, @NotNull Path path, @NotNull MappingVisitor visitor) throws IOException {
                if (format != MappingFormat.ENIGMA_DIR) {
                    throw new IllegalArgumentException("The TAR_XZ format is only supported for the ENIGMA_DIR format. Instead, the " + String.valueOf(format) + " is being used.");
                }
                try (ArchiveVisitor archiveVisitor = new ArchiveVisitor(visitor);
                     InputStream rawIn = Files.newInputStream(path, new OpenOption[0]);
                     XZInputStream decompressedIn = new XZInputStream(rawIn);
                     TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)decompressedIn);
                     InputStreamReader reader = new InputStreamReader((InputStream)tarIn);
                     BufferedReader bufferedReader = new BufferedReader(reader);){
                    TarArchiveEntry tarEntry;
                    while ((tarEntry = tarIn.getNextEntry()) != null) {
                        if (!tarEntry.getName().endsWith("." + MappingFormat.ENIGMA_FILE.fileExt)) continue;
                        EnigmaFileReader.read((Reader)bufferedReader, (MappingVisitor)visitor);
                    }
                }
            }
        }
        ,
        XZ{

            @Override
            public void read(@NotNull MappingFormat format, @NotNull Path path, @NotNull MappingVisitor visitor) throws IOException {
                if (format == MappingFormat.ENIGMA_DIR) {
                    throw new IllegalArgumentException("The XZ container format is not applicable to the " + String.valueOf(format) + " mapping format.");
                }
                try (InputStream rawIn = Files.newInputStream(path, new OpenOption[0]);
                     XZInputStream decompressedIn = new XZInputStream(rawIn);
                     InputStreamReader reader = new InputStreamReader((InputStream)decompressedIn);
                     BufferedReader bufferedReader = new BufferedReader(reader);){
                    MappingReader.read((Reader)bufferedReader, (MappingFormat)format, (MappingVisitor)visitor);
                }
            }
        };


        public abstract void read(@NotNull MappingFormat var1, @NotNull Path var2, @NotNull MappingVisitor var3) throws IOException;
    }

    private static final class ArchiveVisitor
    extends ForwardingMappingVisitor
    implements AutoCloseable {
        private boolean clonedVisitor;
        @NotNull
        private MappingVisitor originalVisitor;
        @Nullable
        private Boolean visitContent = null;

        @NotNull
        private static MappingVisitor optionallyClone(@NotNull MappingVisitor visitor) {
            if (visitor.getFlags().contains(MappingFlag.NEEDS_ELEMENT_UNIQUENESS) || visitor.getFlags().contains(MappingFlag.NEEDS_MULTIPLE_PASSES)) {
                return new MemoryMappingTree();
            }
            return visitor;
        }

        public ArchiveVisitor(@NotNull MappingVisitor visitor) throws IOException {
            super(ArchiveVisitor.optionallyClone(visitor));
            this.originalVisitor = visitor;
            boolean bl = this.clonedVisitor = visitor != this.next;
            if (this.visitHeader()) {
                this.visitNamespaces("source", Collections.singletonList("target"));
            }
        }

        @Override
        public void close() throws IOException {
            if (super.visitEnd()) {
                if (this.clonedVisitor) {
                    ((MappingTree)this.next).accept(this.originalVisitor);
                }
            } else if (this.clonedVisitor) {
                ((MappingTree)this.next).accept(this.originalVisitor);
            } else {
                throw new IllegalStateException("super.visitEnd() returned true without NEEDS_MULTIPLE_PASSES having been declared.");
            }
        }

        public boolean visitContent() throws IOException {
            Boolean visitContent = this.visitContent;
            if (visitContent == null) {
                this.visitContent = super.visitContent();
                return this.visitContent;
            }
            return visitContent;
        }

        public boolean visitEnd() throws IOException {
            return true;
        }

        public boolean visitHeader() throws IOException {
            return false;
        }
    }
}

