/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JarStripper {
    @NotNull
    @Contract(pure=true, mutates="null -> fail; !null -> new")
    public Set<MavenId> getShadedDependencies(InputStream rawJarStream) throws IOException {
        HashSet<MavenId> out = new HashSet<MavenId>();
        try (JarInputStream jarIn = new JarInputStream(rawJarStream, true);){
            JarEntry entry = jarIn.getNextJarEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".properties") && entry.getName().startsWith("META-INF/maven")) {
                    Properties properties = new Properties();
                    properties.load(jarIn);
                    String groupId = properties.getProperty("groupId");
                    String artifactId = properties.getProperty("artifactId");
                    String version = properties.getProperty("version");
                    if (groupId == null || artifactId == null || version == null) {
                        throw new IOException("File is incomplete: " + entry.getName());
                    }
                    out.add(new MavenId(groupId, artifactId, version));
                }
                entry = jarIn.getNextJarEntry();
            }
        }
        return out;
    }

    @NotNull
    public Set<String> aggregate(@NotNull Path cache, @NotNull Set<MavenId> artifacts) throws IOException {
        HashSet<String> blacklistedMembers = new HashSet<String>();
        blacklistedMembers.remove("META-INF/MANIFEST.MF");
        for (MavenId dep : artifacts) {
            Path negativeCachePath = cache.resolve(dep.group.replace('.', '/')).resolve(dep.artifact).resolve(dep.artifact + "-" + dep.version + ".jar.error");
            if (Files.exists(negativeCachePath, new LinkOption[0])) continue;
            Path relativePath = Paths.get(dep.group.replace('.', '/'), new String[0]).resolve(dep.artifact).resolve(dep.artifact + "-" + dep.version + ".jar");
            Path cachePath = cache.resolve(relativePath);
            if (Files.notExists(cachePath, new LinkOption[0])) {
                Files.createDirectories(cachePath.getParent(), new FileAttribute[0]);
                try {
                    Files.copy(URI.create("https://repo1.maven.org/maven2/" + relativePath.toString()).toURL().openStream(), cachePath, new CopyOption[0]);
                }
                catch (IOException e) {
                    Files.createFile(negativeCachePath, new FileAttribute[0]);
                    continue;
                }
            }
            try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(cache, new OpenOption[0]));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.codePointAt(0) == 47) {
                        name = name.substring(0);
                    }
                    blacklistedMembers.add(name);
                    entry = zipIn.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new IOException("Cannot read dependency " + cache.toAbsolutePath().toString(), e);
            }
        }
        return blacklistedMembers;
    }

    public void createStrippedJar(@NotNull Path source, @NotNull Path target, @NotNull Collection<String> removePaths) throws IOException {
        try (JarInputStream in = new JarInputStream(Files.newInputStream(source, new OpenOption[0]));
             OutputStream rawOut = Files.newOutputStream(target, new OpenOption[0]);){
            Manifest man = in.getManifest();
            try (JarOutputStream out = man == null ? new JarOutputStream(rawOut) : new JarOutputStream(rawOut, man);){
                byte[] buffer = new byte[8096];
                JarEntry entry = in.getNextJarEntry();
                while (entry != null) {
                    if (!removePaths.contains(entry.getName())) {
                        out.putNextEntry(entry);
                        int readBytes = in.read(buffer);
                        while (readBytes != -1) {
                            out.write(buffer, 0, readBytes);
                            readBytes = in.read(buffer);
                        }
                    }
                    entry = in.getNextJarEntry();
                }
            }
        }
    }

    public static class MavenId {
        @NotNull
        private final String group;
        @NotNull
        private final String artifact;
        @NotNull
        private final String version;

        public MavenId(@NotNull String g, @NotNull String a, @NotNull String v) {
            this.group = g;
            this.artifact = a;
            this.version = v;
        }

        public int hashCode() {
            return this.group.hashCode() ^ this.artifact.hashCode() ^ this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MavenId) {
                MavenId other = (MavenId)obj;
                return this.group.equals(other.group) && this.artifact.equals(other.artifact) && this.version.equals(other.version);
            }
            return false;
        }

        @NotNull
        public String toGAVNotation() {
            return this.group + ":" + this.artifact + ":" + this.version;
        }
    }
}

