/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class AccessUtil {
    private static final String[] ACCESS_STRING_CACHE_128 = new String[]{null, "ACC_TRANSIENT", "ACC_VARARGS", null};
    private static final String[] ACCESS_STRING_CACHE_32 = new String[]{"ACC_SUPER", "ACC_TRANSITIVE", "ACC_SYNCHRONIZED", "ACC_OPEN"};
    private static final String[] ACCESS_STRING_CACHE_32768 = new String[]{"ACC_MODULE", null, null, "ACC_MANDATED"};
    private static final String[] ACCESS_STRING_CACHE_64 = new String[]{"ACC_BRIDGE", "ACC_VOLATILE", null, null};
    public static final int ANY_VISIBILITY_MODIFIER = 7;
    @NotNull
    private static final @NotNull String @NotNull [] ERROR_CODES = new String[]{"No further information", "Access flag already exists", "Access flag does not yet exist", "Internal transformation failure: Transform is not valid.", "Another visibility-controlling access flag already exists."};
    static final long ERROR_FLAG_EXISTS = 0x100000000L;
    static final long ERROR_FLAG_NOT_EXISTS = 0x100000001L;
    static final long ERROR_TRANSFORM_VALIDITY_ERROR = 0x100000002L;
    static final long ERROR_VISBILITY_CONFLICT = 0x100000003L;
    static final long INT_LSB = 0xFFFFFFFFL;
    public static final int TARGET_ANY = -1;
    public static final int TARGET_CLASS = 0;
    public static final int TARGET_FIELD = 1;
    public static final int TARGET_METHOD = 2;
    public static final int TARGET_MODULE = 3;

    AccessUtil() {
    }

    public static int andAccessTypes(int leftAccessType, int rightAccessType) {
        if (leftAccessType == -1) {
            return rightAccessType;
        }
        if (rightAccessType == -1) {
            return leftAccessType;
        }
        if (leftAccessType == rightAccessType) {
            return leftAccessType;
        }
        throw new IllegalArgumentException("Access categories cannot be combined with AND: " + leftAccessType + ", " + rightAccessType);
    }

    public static final int getAccessCategory(String string) {
        switch (string.toUpperCase(Locale.ROOT)) {
            case "0": {
                return -1;
            }
            case "ACC_ABSTRACT": 
            case "ABSTRACT": {
                return -1;
            }
            case "ACC_ANNOTATION": 
            case "ANNOTATION": {
                return 0;
            }
            case "ACC_DEPRECATED": 
            case "DEPRECATED": {
                return -1;
            }
            case "ACC_ENUM": 
            case "ENUM": {
                return -1;
            }
            case "ACC_FINAL": 
            case "FINAL": {
                return -1;
            }
            case "ACC_INTERFACE": 
            case "INTERFACE": {
                return 0;
            }
            case "ACC_NATIVE": 
            case "NATIVE": {
                return 2;
            }
            case "ACC_PRIVATE": 
            case "PRIVATE": {
                return -1;
            }
            case "ACC_PROTECTED": 
            case "PROTECTED": {
                return -1;
            }
            case "ACC_PUBLIC": 
            case "PUBLIC": {
                return -1;
            }
            case "ACC_RECORD": 
            case "RECORD": {
                return 0;
            }
            case "ACC_STATIC": 
            case "STATIC": {
                return -1;
            }
            case "ACC_STRICT": 
            case "STRICTFP": {
                return 2;
            }
            case "ACC_SYNTHETIC": 
            case "SYNTHETIC": {
                return -1;
            }
            case "ACC_SUPER": 
            case "SUPER": {
                return 0;
            }
            case "ACC_SYNCHRONIZED": 
            case "SYNCHRONIZED": {
                return 2;
            }
            case "ACC_TRANSITIVE": 
            case "TRANSITIVE": {
                return 1;
            }
            case "ACC_OPEN": 
            case "OPEN": {
                return 3;
            }
            case "ACC_BRIDGE": 
            case "BRIDGE": {
                return 2;
            }
            case "ACC_VOLATILE": 
            case "VOLATILE": {
                return 1;
            }
            case "ACC_VARARGS": 
            case "VARARGS": {
                return 2;
            }
            case "ACC_TRANSIENT": 
            case "TRANSIENT": {
                return 3;
            }
            case "ACC_MODULE": 
            case "MODULE": {
                return 0;
            }
            case "ACC_MANDATED": 
            case "MANDATED": {
                return 3;
            }
        }
        throw new IllegalArgumentException(string);
    }

    @NotNull
    static final String getErrorCode(long result) {
        return ERROR_CODES[(int)(result >> 32)];
    }

    public static final int parseAccess(String string) {
        switch (string.toUpperCase(Locale.ROOT)) {
            case "0": {
                return 0;
            }
            case "ACC_ABSTRACT": 
            case "ABSTRACT": {
                return 1024;
            }
            case "ACC_ANNOTATION": 
            case "ANNOTATION": {
                return 8192;
            }
            case "ACC_DEPRECATED": 
            case "DEPRECATED": {
                return 131072;
            }
            case "ACC_ENUM": 
            case "ENUM": {
                return 16384;
            }
            case "ACC_FINAL": 
            case "FINAL": {
                return 16;
            }
            case "ACC_INTERFACE": 
            case "INTERFACE": {
                return 512;
            }
            case "ACC_NATIVE": 
            case "NATIVE": {
                return 256;
            }
            case "ACC_PRIVATE": 
            case "PRIVATE": {
                return 2;
            }
            case "ACC_PROTECTED": 
            case "PROTECTED": {
                return 4;
            }
            case "ACC_PUBLIC": 
            case "PUBLIC": {
                return 1;
            }
            case "ACC_RECORD": 
            case "RECORD": {
                return 65536;
            }
            case "ACC_STATIC": 
            case "STATIC": {
                return 8;
            }
            case "ACC_STRICT": 
            case "STRICTFP": {
                return 2048;
            }
            case "ACC_SYNTHETIC": 
            case "SYNTHETIC": {
                return 4096;
            }
            case "ACC_SUPER": 
            case "SUPER": {
                return 32;
            }
            case "ACC_SYNCHRONIZED": 
            case "SYNCHRONIZED": {
                return 32;
            }
            case "ACC_TRANSITIVE": 
            case "TRANSITIVE": {
                return 32;
            }
            case "ACC_OPEN": 
            case "OPEN": {
                return 32;
            }
            case "ACC_BRIDGE": 
            case "BRIDGE": {
                return 64;
            }
            case "ACC_VOLATILE": 
            case "VOLATILE": {
                return 64;
            }
            case "ACC_VARARGS": 
            case "VARARGS": {
                return 128;
            }
            case "ACC_TRANSIENT": 
            case "TRANSIENT": {
                return 128;
            }
            case "ACC_MODULE": 
            case "MODULE": {
                return 32768;
            }
            case "ACC_MANDATED": 
            case "MANDATED": {
                return 32768;
            }
        }
        throw new IllegalArgumentException(string);
    }

    public static final String stringifyAccess(int access, int type) {
        switch (access) {
            case 0: {
                return "0";
            }
            case 32: {
                return ACCESS_STRING_CACHE_32[type];
            }
            case 64: {
                return ACCESS_STRING_CACHE_64[type];
            }
            case 128: {
                return ACCESS_STRING_CACHE_128[type];
            }
            case 32768: {
                return ACCESS_STRING_CACHE_32768[type];
            }
            case 1024: {
                return "ACC_ABSTRACT";
            }
            case 8192: {
                return "ACC_ANNOTATION";
            }
            case 131072: {
                return "ACC_DEPRECATED";
            }
            case 16384: {
                return "ACC_ENUM";
            }
            case 16: {
                return "ACC_FINAL";
            }
            case 512: {
                return "ACC_INTERFACE";
            }
            case 256: {
                return "ACC_NATIVE";
            }
            case 2: {
                return "ACC_PRIVATE";
            }
            case 4: {
                return "ACC_PROTECTED";
            }
            case 1: {
                return "ACC_PUBLIC";
            }
            case 65536: {
                return "ACC_RECORD";
            }
            case 8: {
                return "ACC_STATIC";
            }
            case 2048: {
                return "ACC_STRICT";
            }
            case 4096: {
                return "ACC_SYNTHETIC";
            }
        }
        return "???";
    }
}

