/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.fast;

import de.geolykt.fast.ConstantBackgroundTask;
import de.geolykt.fast.ProgressBackgroundTask;
import de.geolykt.starloader.api.Galimulator;
import de.geolykt.starloader.api.empire.Star;
import de.geolykt.starloader.api.gui.BackgroundTask;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.stianloader.concurrent.ConcurrentInt62Set;

public final class FastAsynchronousStarlaneTriangulator {
    public static final FastAsynchronousStarlaneTriangulator INSTANCE = new FastAsynchronousStarlaneTriangulator();

    public void connectStars(List<@NotNull Star> stars, double maxX, double maxY) {
        this.connectStars(stars, maxX, maxY, (Int2ObjectFunction<LongSet>)((Int2ObjectFunction)starCount -> new ConcurrentInt62Set(Math.max(Integer.highestOneBit(starCount) >> 5, 16))), ForkJoinPool.commonPool());
    }

    public void connectStars(List<@NotNull Star> stars, double maxX, double maxY, Int2ObjectFunction<LongSet> longSetFactory, Executor executor) {
        int baseIndex;
        int j;
        int i;
        int i2;
        int starCount = stars.size();
        int gridXSize = (int)Math.ceil(maxX * 2.0 / (double)2.8f) + 1;
        int gridYSize = (int)Math.ceil(maxY * 2.0 / (double)2.8f) + 1;
        DimensionalRegion[] grid = new DimensionalRegion[gridXSize * gridYSize];
        LongSet starlanes = (LongSet)longSetFactory.apply(starCount);
        BackgroundTask previousTask = Galimulator.getBackgroundTask();
        Galimulator.setBackgroundTask((BackgroundTask)new ConstantBackgroundTask("Creating grid (" + grid.length + " regions)"));
        for (i2 = 0; i2 < grid.length; ++i2) {
            grid[i2] = new DimensionalRegion();
        }
        for (i2 = 0; i2 < starCount; ++i2) {
            Star star = stars.get(i2);
            int gridX = (int)(((double)star.getX() + maxX) / (double)2.8f);
            int gridY = (int)(((double)star.getY() + maxY) / (double)2.8f);
            grid[gridY * gridXSize + gridX].insert(star);
        }
        for (i2 = 0; i2 < grid.length; ++i2) {
            grid[i2].bake();
        }
        AtomicInteger counter = new AtomicInteger();
        CompletableFuture[] futures = new CompletableFuture[grid.length + (gridXSize - 1) * gridYSize + gridXSize * (gridYSize - 1)];
        Galimulator.setBackgroundTask((BackgroundTask)new ProgressBackgroundTask("Connecting stars: Calculating starlanes", counter, futures.length));
        for (int i3 = 0; i3 < grid.length; ++i3) {
            int gridId = i3;
            futures[i3] = CompletableFuture.runAsync(() -> {
                grid[gridId].connectStars(stars, grid, gridId, gridXSize, starlanes);
                counter.getAndIncrement();
            }, executor);
        }
        int n = grid.length;
        for (i = 0; i < gridYSize; ++i) {
            for (j = 0; j < gridXSize - 1; ++j) {
                baseIndex = i * gridXSize + j;
                futures[n++] = CompletableFuture.runAsync(() -> {
                    grid[baseIndex].connectRegions(grid[baseIndex + 1], starlanes);
                    counter.getAndIncrement();
                }, executor);
            }
        }
        for (i = 0; i < gridYSize - 1; ++i) {
            for (j = 0; j < gridXSize; ++j) {
                baseIndex = i * gridXSize + j;
                futures[n++] = CompletableFuture.runAsync(() -> {
                    grid[baseIndex].connectRegions(grid[baseIndex + gridXSize], starlanes);
                    counter.getAndIncrement();
                }, executor);
            }
        }
        CompletableFuture.allOf(futures).join();
        Galimulator.setBackgroundTask((BackgroundTask)new ConstantBackgroundTask("Connecting stars: Applying starlanes (" + starlanes.size() + ")"));
        LongIterator laneIterator = starlanes.longIterator();
        while (laneIterator.hasNext()) {
            long lane = laneIterator.nextLong();
            Star starA = stars.get((int)(lane & 0xFFFFFFFFL));
            Star starB = stars.get((int)(lane >> 32));
            starA.addNeighbour(starB);
            starB.addNeighbour(starA);
        }
        Galimulator.setBackgroundTask((BackgroundTask)previousTask);
    }

    private static final class DimensionalRegion {
        static final float GRANULARITY_FACTOR = 0.035f;
        static final float BASE_CONNECTION_THRESHOLD = 0.0175f;
        static final float MAP_FACTOR = 5.0f;
        static final float REGION_SIZE = 2.8f;
        private Star[] starArr;
        private final List<Star> stars = new ArrayList<Star>();

        private DimensionalRegion() {
        }

        private static float distanceSq(float x1, float y1, float x2, float y2) {
            return (x1 -= x2) * x1 + (y1 -= y2) * y1;
        }

        private static void handleReachabilities(Int2ObjectMap<IntSet> reachabilities, int a, int b) {
            IntSet reachabilitiesA = (IntSet)reachabilities.get(a);
            IntSet reachabilitiesB = (IntSet)reachabilities.get(b);
            if (reachabilitiesA.size() > reachabilitiesB.size()) {
                DimensionalRegion.mergeNetworks(reachabilitiesA, reachabilitiesB, reachabilities);
            } else {
                DimensionalRegion.mergeNetworks(reachabilitiesB, reachabilitiesA, reachabilities);
            }
        }

        private static long hash(long a, long b) {
            if (a > b) {
                return a << 32 | b;
            }
            return b << 32 | a;
        }

        private static void mergeNetworks(IntSet absorber, IntSet absorbed, Int2ObjectMap<IntSet> networks) {
            absorber.addAll((IntCollection)absorbed);
            IntIterator intIterator = absorbed.iterator();
            while (intIterator.hasNext()) {
                int member = (Integer)intIterator.next();
                networks.put(member, (Object)absorber);
            }
        }

        void bake() {
            this.starArr = this.stars.toArray(new Star[0]);
        }

        private void connectRegions(DimensionalRegion target, LongSet out) {
            if (this.starArr.length == 0 || target.starArr.length == 0) {
                return;
            }
            float cutoff = 0.0175f;
            boolean modified = false;
            while (!modified) {
                for (Star starT : target.starArr) {
                    for (Star starS : this.starArr) {
                        if (!(DimensionalRegion.distanceSq(starS.getX(), starS.getY(), starT.getX(), starT.getY()) < cutoff)) continue;
                        out.add(DimensionalRegion.hash(starT.getUID() + 1, starS.getUID() + 1));
                        modified = true;
                    }
                }
                assert ((cutoff += 0.035f) < 5.6f) : "Cutoff limit exceeeded";
            }
        }

        void connectStars(List<Star> stars, DimensionalRegion[] grid, int regionId, int gridWidth, LongSet out) {
            Int2ObjectOpenHashMap networks = new Int2ObjectOpenHashMap(this.starArr.length);
            for (Star star : this.starArr) {
                IntOpenHashSet set = new IntOpenHashSet();
                set.add(star.getUID() + 1);
                networks.put(star.getUID() + 1, (Object)set);
            }
            this.selfFastInterconnect(out, (Int2ObjectMap<IntSet>)networks);
            this.intertwineNets(stars, out, (Int2ObjectMap<IntSet>)networks);
        }

        void insert(Star star) {
            this.stars.add(star);
        }

        private void intertwineNets(List<Star> stars, LongSet out, Int2ObjectMap<IntSet> networks) {
            int largestNetwork = 0;
            for (Star star : this.starArr) {
                largestNetwork = Math.max(largestNetwork, ((IntSet)networks.get(star.getUID() + 1)).size());
            }
            block1: while (largestNetwork != this.starArr.length) {
                for (Star star : this.starArr) {
                    float dist;
                    float minDist = Float.MAX_VALUE;
                    Star minDistStar = null;
                    IntSet sourceNetwork = (IntSet)networks.get(star.getUID() + 1);
                    for (Star other : this.starArr) {
                        if (sourceNetwork.contains(other.getUID() + 1) || !((dist = DimensionalRegion.distanceSq(star.getX(), star.getY(), other.getX(), other.getY())) < minDist)) continue;
                        minDist = dist;
                        minDistStar = other;
                    }
                    assert (minDistStar != null) : "There should be at least one remaining star at " + networks + " networks";
                    Star sourceStar = star;
                    Star targetStar = minDistStar;
                    if (minDist > 0.14f) {
                        IntIterator sourceNetworkIterator = sourceNetwork.iterator();
                        while (sourceNetworkIterator.hasNext()) {
                            Star candidate = stars.get(sourceNetworkIterator.nextInt());
                            dist = DimensionalRegion.distanceSq(candidate.getX(), candidate.getY(), targetStar.getX(), targetStar.getY());
                            if (!(dist < minDist)) continue;
                            minDist = dist;
                            sourceStar = candidate;
                        }
                    }
                    int sourceID = sourceStar.getUID() + 1;
                    int targetID = targetStar.getUID() + 1;
                    out.add(DimensionalRegion.hash(sourceID, targetID));
                    DimensionalRegion.handleReachabilities(networks, sourceID, targetID);
                    largestNetwork = Math.max(largestNetwork, ((IntSet)networks.get(sourceID)).size());
                    if (largestNetwork == this.starArr.length) continue block1;
                }
            }
        }

        private void selfFastInterconnect(LongSet out, Int2ObjectMap<IntSet> reachabilities) {
            for (int i = 0; i < this.starArr.length; ++i) {
                Star a = this.starArr[i];
                for (int j = 0; j < i; ++j) {
                    Star b = this.starArr[j];
                    if (!(DimensionalRegion.distanceSq(a.getX(), a.getY(), b.getX(), b.getY()) < 0.0175f)) continue;
                    out.add(DimensionalRegion.hash(a.getUID() + 1, b.getUID() + 1));
                    DimensionalRegion.handleReachabilities(reachabilities, a.getUID() + 1, b.getUID() + 1);
                }
            }
        }
    }
}

