/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.cdl;

import de.geolykt.starloader.transformers.ASMTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.LoggerFactory;

public class CDLASMTransformer
extends ASMTransformer {
    private static final String TARGET = "snoddasmannen/galimulator/Person";
    private static final String ATOMIC_INT = "java/util/concurrent/atomic/AtomicInteger";

    public boolean accept(@NotNull ClassNode node) {
        if (!node.name.equals(TARGET)) {
            return false;
        }
        int modified = 0;
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                if (insn.getOpcode() != 16) continue;
                IntInsnNode iinsn = (IntInsnNode)insn;
                if (iinsn.operand != 20) continue;
                FieldInsnNode injectFInsn = new FieldInsnNode(178, "de/geolykt/cdl/CDLExtension", "MAX_FAMILY_SIZE", "Ljava/util/concurrent/atomic/AtomicInteger;");
                MethodInsnNode injectMInsn = new MethodInsnNode(182, ATOMIC_INT, "get", "()I");
                method.instructions.insertBefore(insn, (AbstractInsnNode)injectFInsn);
                method.instructions.insertBefore(insn, (AbstractInsnNode)injectMInsn);
                method.instructions.remove(insn);
                ++modified;
            }
        }
        if (modified != 2) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Modified the maximum family size constant {} times, expected 2. This may be a bug.", (Object)modified);
        }
        return modified != 0;
    }

    public boolean isValidTarget(@NotNull String internalName) {
        return TARGET.equals(internalName);
    }

    public int getPriority() {
        return 110;
    }
}

