/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.cdl;

import de.geolykt.cdl.CDLASMTransformer;
import de.geolykt.starloader.api.NullUtils;
import de.geolykt.starloader.api.event.EventHandler;
import de.geolykt.starloader.api.event.EventManager;
import de.geolykt.starloader.api.event.Listener;
import de.geolykt.starloader.api.event.lifecycle.ApplicationStopEvent;
import de.geolykt.starloader.api.gui.modconf.ConfigurationSection;
import de.geolykt.starloader.api.gui.modconf.IntegerOption;
import de.geolykt.starloader.api.gui.modconf.ModConf;
import de.geolykt.starloader.mod.Extension;
import de.geolykt.starloader.transformers.ASMTransformer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.NotNull;

public class CDLExtension
extends Extension {
    public static final AtomicInteger MAX_FAMILY_SIZE = new AtomicInteger(20);

    public void preInitialize() {
        MinestomRootClassLoader.getInstance().addTransformer((ASMTransformer)new CDLASMTransformer());
    }

    public void postInitialize() {
        this.loadConfig();
        ConfigurationSection conf = ModConf.createSection((String)"Custom Dynasty Limiter");
        final IntegerOption option = conf.addIntegerOption("Maximum Family Size", MAX_FAMILY_SIZE.get(), 20, 1, 0x7FFFFFFE, NullUtils.asList((Object[])new Integer[]{20}));
        try {
            option.addValueChangeListenerI(this::saveConfig);
        }
        catch (IncompatibleClassChangeError err) {
            this.getLogger().warn("Unable to work with IntegerOption#addValueChangeListenerI; Using save-on-quit instead. Behaviour may be warped - that is changed only apply after a restart.");
            this.getLogger().debug("Unable to work with IntegerOption#addValueChangeListenerI", (Throwable)err);
            EventManager.registerListener((Listener)new Listener(){

                @EventHandler
                public void onStop(ApplicationStopEvent e) {
                    CDLExtension.this.saveConfig(option.getValue());
                }
            });
        }
    }

    public void saveConfig(int value) {
        MAX_FAMILY_SIZE.set(value);
        try {
            Files.write(this.getSavePath(), Integer.toString(value).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            this.getLogger().error("Unable to save custom dynasty limit", (Throwable)ex);
        }
    }

    @NotNull
    public Path getSavePath() {
        List urls = this.getDescription().getOrigin().files;
        Path file = null;
        if (urls.size() == 1) {
            try {
                file = Paths.get(((URL)urls.get(0)).toURI()).resolveSibling("custom-dynasty-limiter.dat");
            }
            catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException ex) {
                this.getLogger().error("Unable to obtain configuration save path", (Throwable)ex);
            }
        }
        if (file == null) {
            file = Paths.get("mods", "custom-dynasty-limiter.dat");
        }
        return (Path)NullUtils.requireNotNull(file);
    }

    public void loadConfig() {
        try {
            Path file = this.getSavePath();
            if (Files.notExists(file, new LinkOption[0])) {
                this.getLogger().info("Skipping loading of custom dynasty limit as the config does not exist yet");
                return;
            }
            String data = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            MAX_FAMILY_SIZE.set(Integer.parseUnsignedInt(data));
        }
        catch (IOException | NumberFormatException ex) {
            this.getLogger().error("Unable to load custom dynasty limit", (Throwable)ex);
        }
    }
}

