/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.archive.TarCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.Tar;
import org.stianloader.sml6.GradleUtilities;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

@CacheableTask
public abstract class XZTarBallerTask
extends Tar {
    public XZTarBallerTask() {
        this.getArchiveBaseName().convention(GradleUtilities.getBaseArchiveName(this.getProject()));
        this.getDestinationDirectory().convention(GradleUtilities.getDistsDirectory(this.getProject()));
        this.getArchiveExtension().unset().convention((Object)"tar.xz");
        this.getCompressionLevel().convention((Object)6);
    }

    protected CopyAction createCopyAction() {
        return new TarCopyAction(((RegularFile)this.getArchiveFile().get()).getAsFile(), destination -> new XZOutputStream((OutputStream)new FileOutputStream(destination), (FilterOptions)new LZMA2Options(((Integer)this.getCompressionLevel().get()).intValue())), this.isPreserveFileTimestamps());
    }

    @Input
    @Optional
    public abstract Property<Integer> getCompressionLevel();

    @Inject
    protected abstract ProjectLayout getLayout();
}

