/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import java.io.File;
import java.util.Date;
import javax.inject.Inject;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.stianloader.sml6.GradleUtilities;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
@ApiStatus.NonExtendable
public abstract class AbstractArtifactTask
extends ConventionTask {
    public AbstractArtifactTask() {
        this.getArchiveBaseName().convention(GradleUtilities.getBaseArchiveName(this.getProject()));
        this.getDestinationDirectory().convention(GradleUtilities.getDistsDirectory(this.getProject()));
        this.getArchiveVersion().convention(GradleUtilities.getVersion(this.getProject()));
        this.getArchiveDate().convention(this.getArchiveFile().getAsFile().map(f -> new Date(f.lastModified())));
        this.getArchiveExtension().convention((Object)"");
        this.getArchiveAppendix().convention((Object)"");
        this.getArchiveClassifier().convention((Object)"");
        Provider defaultFilenameProvider = this.getArchiveBaseName().zip(this.getArchiveAppendix(), GradleUtilities::appendFilenamePart).zip(this.getArchiveVersion(), GradleUtilities::appendFilenamePart).zip(this.getArchiveClassifier(), GradleUtilities::appendFilenamePart).zip(this.getArchiveExtension(), GradleUtilities::appendFileExtension);
        this.getArchiveFileName().convention(defaultFilenameProvider);
        this.getArchiveFile().convention(this.getDestinationDirectory().file(this.getArchiveFileName()));
    }

    @NotNull
    public PublishArtifact asArtifact() {
        return (PublishArtifact)this.getProject().getObjects().newInstance(AbstractArtifactTaskPublishArtifact.class, new Object[]{this});
    }

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveAppendix();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveBaseName();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveClassifier();

    @Internal(value="Transitively depends on getArchiveFile()")
    public abstract Property<Date> getArchiveDate();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveExtension();

    @OutputFile
    public abstract RegularFileProperty getArchiveFile();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveFileName();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract Property<String> getArchiveVersion();

    @Internal(value="getArchiveFile() is the actual output")
    public abstract DirectoryProperty getDestinationDirectory();

    protected static class AbstractArtifactTaskPublishArtifact
    implements PublishArtifact {
        private final TaskDependency dependencies;
        @NotNull
        private final AbstractArtifactTask task;

        @Inject
        public AbstractArtifactTaskPublishArtifact(@NotNull TaskDependencyFactory factory, @NotNull AbstractArtifactTask task) {
            this.dependencies = factory.configurableDependency().add(new Object[]{task});
            this.task = task;
        }

        public TaskDependency getBuildDependencies() {
            return this.dependencies;
        }

        public @Nullable String getClassifier() {
            return (String)this.task.getArchiveClassifier().getOrNull();
        }

        public @Nullable Date getDate() {
            return (Date)this.task.getArchiveDate().getOrNull();
        }

        public String getExtension() {
            return (String)this.task.getArchiveExtension().get();
        }

        public File getFile() {
            return ((RegularFile)this.task.getArchiveFile().get()).getAsFile();
        }

        public String getName() {
            return (String)this.task.getArchiveBaseName().get();
        }

        public String getType() {
            return (String)this.task.getArchiveExtension().get();
        }
    }
}

