package de.geolykt.starloader.api.utils;

import de.geolykt.starloader.api.Galimulator;

/**
 * An enumeration of all the currently valid types of words that can be generated by
 * galimulator's word generator.
 * This enumeration finds use in {@link Galimulator#generateRandomName(RandomNameType)}.
 *
 * @author Geolykt
 * @since 2.0.0
 */
public enum RandomNameType {
    ADJECTIVE,
    FACTION_NAME,
    IDENTIFIER,

    /**
     * Quest names have "The [ADJECTIVE] [NOUN]" as a pattern.
     * To just get the noun, use {@link #QUEST_NOMINATOR}.
     *
     * @since 2.0.0
     */
    QUEST_NAME,

    /**
     * The quest nominator is the noun of the quest name.
     * Quest names have "The [ADJECTIVE] [NOUN]" pattern.
     *
     * @since 2.0.0
     */
    QUEST_NOMINATOR,
    REVOLT_NAME,
    SHIP_NAME,
    VANITY_NAME;
}
