/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.glsl;

import org.jglrxavpok.jlsl.glsl.GLSL;

public class Vec2 {
    public double x;
    public double y;

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @GLSL.Substitute(value="+", usesParenthesis=false, ownerBefore=true)
    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    @GLSL.Substitute(value="/", usesParenthesis=false, ownerBefore=true)
    public Vec2 div(double i) {
        return new Vec2(this.x / i, this.y / i);
    }

    @GLSL.Substitute(value="/", usesParenthesis=false, ownerBefore=true)
    public Vec2 div(int i) {
        return new Vec2(this.x / (double)i, this.y / (double)i);
    }

    @GLSL.Substitute(value="/", usesParenthesis=false, ownerBefore=true)
    public Vec2 div(Vec2 v) {
        return new Vec2(this.x / v.x, this.y / v.y);
    }

    public double length() {
        double dx = this.x;
        double dy = this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @GLSL.Substitute(value="*", usesParenthesis=false, ownerBefore=true)
    public Vec2 mul(double i) {
        return new Vec2(this.x * i, this.y * i);
    }

    @GLSL.Substitute(value="*", usesParenthesis=false, ownerBefore=true)
    public Vec2 mul(int i) {
        return new Vec2(this.x * (double)i, this.y * (double)i);
    }

    @GLSL.Substitute(value="*", usesParenthesis=false, ownerBefore=true)
    public Vec2 mul(Vec2 v) {
        return new Vec2(this.x * v.x, this.y * v.y);
    }

    public Vec2 normalize() {
        double l = this.length();
        double x1 = this.x / l;
        double y1 = this.y / l;
        return new Vec2(x1, y1);
    }

    @GLSL.Substitute(value="-", usesParenthesis=false, ownerBefore=true)
    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }
}

