/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import org.jglrxavpok.jlsl.CodeFilter;
import org.jglrxavpok.jlsl.JLSLContext;
import org.jglrxavpok.jlsl.fragments.AnnotationFragment;
import org.jglrxavpok.jlsl.fragments.CodeFragment;
import org.jglrxavpok.jlsl.fragments.MethodCallFragment;
import org.jglrxavpok.jlsl.fragments.StartOfMethodFragment;

public class ObfuscationFilter
implements CodeFilter {
    private ArrayList<MethodEntry> entries = new ArrayList();
    private int nbr;

    @Override
    public CodeFragment filter(CodeFragment fragment) {
        if (fragment instanceof MethodCallFragment) {
            MethodCallFragment methodCallFrag = (MethodCallFragment)fragment;
            for (CodeFragment child : methodCallFrag.getChildren()) {
                if (!(child instanceof AnnotationFragment)) continue;
                AnnotationFragment annot = (AnnotationFragment)child;
                if (!annot.name.equals(NonObfuscable.class.getCanonicalName())) continue;
                return fragment;
            }
            if (!methodCallFrag.methodOwner.equals(((Class)JLSLContext.currentInstance.getCurrentObject()).getCanonicalName())) {
                return fragment;
            }
            MethodEntry entry = this.getMethodEntry(methodCallFrag.methodName, methodCallFrag.methodOwner, methodCallFrag.argumentsTypes);
            methodCallFrag.methodName = entry.newName;
        } else if (fragment instanceof StartOfMethodFragment) {
            StartOfMethodFragment startMethodCallFrag = (StartOfMethodFragment)fragment;
            for (CodeFragment child : startMethodCallFrag.getChildren()) {
                if (!(child instanceof AnnotationFragment)) continue;
                AnnotationFragment annot = (AnnotationFragment)child;
                if (!annot.name.equals(NonObfuscable.class.getCanonicalName())) continue;
                return fragment;
            }
            if (!startMethodCallFrag.owner.equals(((Class)JLSLContext.currentInstance.getCurrentObject()).getCanonicalName())) {
                return fragment;
            }
            MethodEntry entry = this.getMethodEntry(startMethodCallFrag.name, startMethodCallFrag.owner, startMethodCallFrag.argumentsTypes.toArray(new String[0]));
            startMethodCallFrag.name = entry.newName;
        }
        return fragment;
    }

    private MethodEntry getMethodEntry(String name, String owner, String[] argumentsTypes) {
        for (MethodEntry entry : this.entries) {
            if (!entry.name.equals(name) || !entry.owner.equals(owner) || !Arrays.deepEquals(argumentsTypes, entry.argumentTypes)) continue;
            return entry;
        }
        MethodEntry entry = new MethodEntry(name, owner, argumentsTypes, this.getNewName());
        this.entries.add(entry);
        return entry;
    }

    private String getNewName() {
        char last = (char)(97 + this.nbr % 26);
        int nbr1 = this.nbr - 26;
        String s = "";
        while (nbr1 >= 0) {
            s = (char)(97 + (nbr1 -= 26) % 26) + s;
        }
        ++this.nbr;
        System.out.println("created name " + s + last);
        return s + last;
    }

    private static class MethodEntry {
        public String name;
        public String owner;
        public String[] argumentTypes;
        public String newName;

        public MethodEntry(String name, String owner, String[] argumentTypes, String newName) {
            this.name = name;
            this.owner = owner;
            this.argumentTypes = argumentTypes;
            this.newName = newName;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonObfuscable {
    }
}

