/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode;
import org.jglrxavpok.jlsl.filters.CodeFilter;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Class;

public class ObfuscationFilter
implements CodeFilter<GLSLBytecode.Root, GLSLBytecode.Root> {
    private final Map<String, String> old2New = new HashMap<String, String>();
    private final Set<String> usedNames = new HashSet<String>();
    private final Map<Class<?>, Processor<?>> processors = new HashMap();
    private final Set<GLSLBytecode.Node> visited = new HashSet<GLSLBytecode.Node>();
    public static final /* synthetic */ String jvmdowngrader$nestMembers = "org/jglrxavpok/jlsl/filters/ObfuscationFilter$Processor";

    public ObfuscationFilter() {
        this.registerProcessor(GLSLBytecode.Method.class, this::process);
        this.registerProcessor(GLSLBytecode.Value.MethodCall.class, this::process);
        this.registerProcessor(GLSLBytecode.Body.class, this::process);
        this.registerProcessor(GLSLBytecode.Value.Reference.Variable.class, this::process);
        this.registerProcessor(GLSLBytecode.Value.Reference.Index.class, this::process);
        this.registerProcessor(GLSLBytecode.Field.class, this::process);
        this.registerProcessor(GLSLBytecode.Statement.DeclareVariable.class, this::process);
        this.registerProcessor(GLSLBytecode.Statement.If.class, this::process);
        this.registerProcessor(GLSLBytecode.Statement.UpdateVariable.class, Processor.PASS_THROUGH);
        this.registerProcessor(GLSLBytecode.Value.Constant.class, Processor.PASS_THROUGH);
        this.registerProcessor(GLSLBytecode.Statement.Return.class, Processor.PASS_THROUGH);
        this.registerProcessor(GLSLBytecode.Method.Parameter.class, this::process);
        this.registerProcessor(GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo.class, this::process);
        this.registerProcessor(GLSLBytecode.Statement.Condition.LessThanOrEqualTo.class, this::process);
        this.old2New.put("this", "this");
    }

    private <N extends GLSLBytecode.Node> void registerProcessor(Class<N> clazz, Processor<? super N> processor) {
        this.processors.put(clazz, processor);
    }

    @Override
    @NotNull
    public GLSLBytecode.Root filter(@NotNull GLSLBytecode.Root input) {
        ArrayList<? extends GLSLBytecode.TopLevelNode> nodes = new ArrayList<GLSLBytecode.TopLevelNode>(input.nodes());
        for (int i = 0; i < nodes.size(); ++i) {
            GLSLBytecode.TopLevelNode node = (GLSLBytecode.TopLevelNode)nodes.get(i);
            nodes.set(i, this.obfuscate(node));
        }
        return new GLSLBytecode.Root(input.version(), (List<? extends GLSLBytecode.TopLevelNode>)nodes);
    }

    private <N extends GLSLBytecode.Node> N obfuscate(@NotNull N node) {
        if (this.visited.contains(node)) {
            return node;
        }
        this.visited.add(node);
        AtomicReference<N> result = new AtomicReference<N>(node);
        Class<?> clazz = node.getClass();
        Processor<?> processor = this.processors.get(clazz);
        if (processor != null) {
            processor.process(node, result::set);
        } else {
            System.out.println(ObfuscationFilter.jvmdowngrader$concat1(clazz.getCanonicalName().replace(ObfuscationFilter.jvmdowngrader$concat(J_L_Class.getPackageName(clazz)), "")));
        }
        return result.get();
    }

    @NotNull
    private <N extends GLSLBytecode.Node> List<N> obfuscateAll(@NotNull List<N> nodes) {
        ArrayList<GLSLBytecode.Node> result = new ArrayList<GLSLBytecode.Node>(nodes.size());
        for (GLSLBytecode.Node node : nodes) {
            result.add(this.obfuscate(node));
        }
        return result;
    }

    private String getNewName(String old) {
        StringBuilder sb;
        String name;
        if (this.old2New.containsKey(old)) {
            return this.old2New.get(old);
        }
        if (this.usedNames.contains(old)) {
            return old;
        }
        do {
            sb = new StringBuilder();
            for (int i = 0; i < 10; ++i) {
                char c = (char)(Math.random() * 26.0 + 97.0);
                sb.append(c);
            }
        } while (this.usedNames.contains(name = sb.toString()));
        this.usedNames.add(name);
        this.old2New.put(old, name);
        return name;
    }

    private void process(GLSLBytecode.Value.MethodCall methodCall, Consumer<GLSLBytecode.Value.MethodCall> update) {
        GLSLBytecode.Value callingField = methodCall.callingField();
        if (callingField != null) {
            callingField = this.obfuscate(callingField);
        }
        List<? extends GLSLBytecode.Value> parameters = this.obfuscateAll(methodCall.parameters());
        update.accept(new GLSLBytecode.Value.MethodCall(callingField, methodCall.listened(), parameters));
    }

    private void process(GLSLBytecode.Method method, Consumer<GLSLBytecode.Method> update) {
        String newName = this.getNewName(method.name());
        List<GLSLBytecode.Method.Parameter> params = this.obfuscateAll(method.parameters());
        GLSLBytecode.Body body = this.obfuscate(method.body());
        GLSLBytecode.Method newMethod = new GLSLBytecode.Method(method.returnType(), newName, params, body);
        update.accept(newMethod);
    }

    private void process(@NotNull GLSLBytecode.Body body, @NotNull Consumer<GLSLBytecode.Body> update) {
        List<GLSLBytecode.Statement> statements = this.obfuscateAll(body.statements());
        update.accept(new GLSLBytecode.Body(statements));
    }

    private void process(@NotNull GLSLBytecode.Value.Reference.Variable variable, @NotNull Consumer<GLSLBytecode.Value.Reference.Variable> update) {
        String newName = this.getNewName(variable.reference());
        update.accept(new GLSLBytecode.Value.Reference.Variable(newName));
    }

    private void process(@NotNull GLSLBytecode.Field field, @NotNull Consumer<GLSLBytecode.Field> update) {
        String newName = this.getNewName(field.name());
        update.accept(new GLSLBytecode.Field(field.fieldType(), newName, field.valueType()));
    }

    private void process(@NotNull GLSLBytecode.Value.Reference.Index index, @NotNull Consumer<GLSLBytecode.Value.Reference.Index> update) {
        String newIndex = this.getNewName(index.index());
        GLSLBytecode.Value previous = this.obfuscate(index.previous());
        update.accept(new GLSLBytecode.Value.Reference.Index(previous, newIndex));
    }

    private void process(@NotNull GLSLBytecode.Statement.DeclareVariable declareVariable, @NotNull Consumer<GLSLBytecode.Statement.DeclareVariable> update) {
        GLSLBytecode.Type type = this.obfuscate(declareVariable.type());
        String newName = this.getNewName(declareVariable.name());
        GLSLBytecode.Value value = declareVariable.value() == null ? null : this.obfuscate(declareVariable.value());
        GLSLBytecode.Statement.DeclareVariable newDeclareVariable = new GLSLBytecode.Statement.DeclareVariable(type, newName, value);
        update.accept(newDeclareVariable);
    }

    private void process(@NotNull GLSLBytecode.Statement.If ifStatement, @NotNull Consumer<GLSLBytecode.Statement.If> update) {
        GLSLBytecode.Statement.Condition condition = this.obfuscate(ifStatement.condition());
        GLSLBytecode.Body body = this.obfuscate(ifStatement.body());
        GLSLBytecode.Body elseBody = ifStatement.elseBody() == null ? null : this.obfuscate(ifStatement.elseBody());
        GLSLBytecode.Statement.If newIfStatement = new GLSLBytecode.Statement.If(condition, body, elseBody);
        update.accept(newIfStatement);
    }

    private void process(GLSLBytecode.Method.Parameter parameter, Consumer<GLSLBytecode.Method.Parameter> update) {
        String newName = this.getNewName(parameter.name());
        GLSLBytecode.Method.Parameter newParameter = new GLSLBytecode.Method.Parameter(parameter.type(), newName);
        update.accept(newParameter);
    }

    private void process(GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo greaterThanOrEqualTo, Consumer<GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo> update) {
        GLSLBytecode.Value left = this.obfuscate(greaterThanOrEqualTo.left());
        GLSLBytecode.Value right = this.obfuscate(greaterThanOrEqualTo.right());
        GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo newGreaterThanOrEqualTo = new GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo(left, right);
        update.accept(newGreaterThanOrEqualTo);
    }

    private void process(GLSLBytecode.Statement.Condition.LessThanOrEqualTo lessThanOrEqualTo, Consumer<GLSLBytecode.Statement.Condition.LessThanOrEqualTo> update) {
        GLSLBytecode.Value left = this.obfuscate(lessThanOrEqualTo.left());
        GLSLBytecode.Value right = this.obfuscate(lessThanOrEqualTo.right());
        GLSLBytecode.Statement.Condition.LessThanOrEqualTo newLessThanOrEqualTo = new GLSLBytecode.Statement.Condition.LessThanOrEqualTo(left, right);
        update.accept(newLessThanOrEqualTo);
    }

    private static /* synthetic */ String jvmdowngrader$concat(String string) {
        return string + ".";
    }

    private static /* synthetic */ String jvmdowngrader$concat1(String string) {
        return "Missing obfuscation processor for " + string;
    }

    private static interface Processor<N extends GLSLBytecode.Node> {
        @NotNull
        public static final Processor<GLSLBytecode.Node> PASS_THROUGH = (node, update) -> update.accept(node);
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/filters/ObfuscationFilter";

        public void process(@NotNull N var1, @NotNull Consumer<N> var2);
    }
}

