/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion.glslbytecode;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.jlsl.conversion.IndentedStringWriter;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;

public class GLSLBytecode {
    public static final Type INT = new Type("int");
    public static final Type FLOAT = new Type("float");
    public static final Type BOOL = new Type("bool");
    public static final /* synthetic */ String jvmdowngrader$nestMembers = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$TopLevelNode:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Comment:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Comment$Block:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Comment$Line:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Type:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value$MethodCall:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value$Reference:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value$Reference$Index:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value$Reference$Variable:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Value$Constant:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Return:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$UpdateVariable:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$DeclareVariable:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$If:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$LessThanOrEqualTo:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$LessThan:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$GreaterThanOrEqualTo:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$GreaterThan:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$Or:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$And:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$NotEqualTo:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$Not:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Statement$Condition$EqualTo:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Body:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Method:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Method$Parameter:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Field:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Field$Type:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Root:org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode$Node";

    public static final class Type
    extends J_L_Record
    implements Node {
        private final String name;
        public static final Type VOID = new Type("void");
        public static final Type INT = new Type("int");
        public static final Type LONG = new Type("long");
        public static final Type FLOAT = new Type("float");
        public static final Type DOUBLE = new Type("double");
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public Type(String name) {
            this.name = name;
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            writer.write(this.name);
        }

        public final String toString() {
            return Type.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Type.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Type.jvmdowngrader$equals(this, o);
        }

        public String name() {
            return this.name;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Type type) {
            Type type2 = type;
            return "GLSLBytecode$Type[" + "name=" + type.name + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Type type) {
            Object[] objectArray = new Object[]{type.name};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Type type, Object object) {
            if (type == object) {
                return true;
            }
            if (object != null && object instanceof Type) {
                Type type2 = (Type)object;
                if (Objects.equals(type.name, type2.name)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface TopLevelNode
    extends Node {
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";
    }

    public static interface Comment
    extends Statement {
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public static final class Block
        extends J_L_Record
        implements Comment {
            @NotNull
            private final String comment;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public Block(@NotNull String comment) {
                this.comment = comment;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("/* ");
                writer.write(this.comment);
                writer.write(" */");
            }

            public final String toString() {
                return Block.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return Block.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Block.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public String comment() {
                return this.comment;
            }

            private static /* synthetic */ String jvmdowngrader$toString(Block block) {
                Block block2 = block;
                return "GLSLBytecode$Comment$Block[" + "comment=" + block.comment + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(Block block) {
                Object[] objectArray = new Object[]{block.comment};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(Block block, Object object) {
                if (block == object) {
                    return true;
                }
                if (object != null && object instanceof Block) {
                    Block block2 = (Block)object;
                    if (Objects.equals(block.comment, block2.comment)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static final class Line
        extends J_L_Record
        implements Comment {
            @NotNull
            private final String comment;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public Line(@NotNull String comment) {
                this.comment = comment;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("// ");
                writer.write(this.comment);
                writer.newLine();
            }

            public final String toString() {
                return Line.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return Line.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Line.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public String comment() {
                return this.comment;
            }

            private static /* synthetic */ String jvmdowngrader$toString(Line line) {
                Line line2 = line;
                return "GLSLBytecode$Comment$Line[" + "comment=" + line.comment + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(Line line) {
                Object[] objectArray = new Object[]{line.comment};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(Line line, Object object) {
                if (line == object) {
                    return true;
                }
                if (object != null && object instanceof Line) {
                    Line line2 = (Line)object;
                    if (Objects.equals(line.comment, line2.comment)) {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static interface Value
    extends Node {
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        @NotNull
        default public Reference.Index index(@NotNull String index) {
            return new Reference.Index(this, index);
        }

        public static interface Reference
        extends Value {
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public static final class Index
            extends J_L_Record
            implements Reference {
                @NotNull
                private final Value previous;
                @NotNull
                private final String index;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public Index(@NotNull Value previous, @NotNull String index) {
                    this.previous = previous;
                    this.index = index;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.previous.generateSource(writer);
                    writer.write(".");
                    writer.write(this.index);
                }

                public final String toString() {
                    return Index.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return Index.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return Index.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value previous() {
                    return this.previous;
                }

                @NotNull
                public String index() {
                    return this.index;
                }

                private static /* synthetic */ String jvmdowngrader$toString(Index index) {
                    Index index2 = index;
                    return "GLSLBytecode$Value$Reference$Index[" + "previous=" + index.previous + ", " + "index=" + index.index + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(Index index) {
                    Object[] objectArray = new Object[]{index.previous, index.index};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(Index index, Object object) {
                    if (index == object) {
                        return true;
                    }
                    if (object != null && object instanceof Index) {
                        Index index2 = (Index)object;
                        if (Objects.equals(index.previous, index2.previous) && Objects.equals(index.index, index2.index)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class Variable
            extends J_L_Record
            implements Reference {
                @NotNull
                private final String reference;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public Variable(@NotNull String reference) {
                    this.reference = reference;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write(this.reference);
                }

                public final String toString() {
                    return Variable.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return Variable.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return Variable.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public String reference() {
                    return this.reference;
                }

                private static /* synthetic */ String jvmdowngrader$toString(Variable variable) {
                    Variable variable2 = variable;
                    return "GLSLBytecode$Value$Reference$Variable[" + "reference=" + variable.reference + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(Variable variable) {
                    Object[] objectArray = new Object[]{variable.reference};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(Variable variable, Object object) {
                    if (variable == object) {
                        return true;
                    }
                    if (object != null && object instanceof Variable) {
                        Variable variable2 = (Variable)object;
                        if (Objects.equals(variable.reference, variable2.reference)) {
                            return true;
                        }
                    }
                    return false;
                }
            }
        }

        public static final class MethodCall
        extends J_L_Record
        implements Value,
        Statement {
            @Nullable
            private final Value callingField;
            private final boolean listened;
            @NotNull
            private final List<? extends Value> parameters;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public MethodCall(@Nullable Value callingField, boolean listened, Value ... parameters) {
                this(callingField, listened, J_U_List.of((Object[])parameters));
            }

            public MethodCall(@Nullable Value callingField, boolean listened, @NotNull List<? extends Value> parameters) {
                this.callingField = callingField;
                this.listened = listened;
                this.parameters = parameters;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                if (this.callingField != null) {
                    this.callingField.generateSource(writer);
                }
                writer.write("(");
                for (int i = 0; i < this.parameters.size(); ++i) {
                    if (i > 0) {
                        writer.write(", ");
                    }
                    this.parameters.get(i).generateSource(writer);
                }
                writer.write(")");
                if (!this.listened) {
                    writer.write(";");
                    writer.newLine();
                }
            }

            public final String toString() {
                return MethodCall.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return MethodCall.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return MethodCall.jvmdowngrader$equals(this, o);
            }

            @Nullable
            public Value callingField() {
                return this.callingField;
            }

            public boolean listened() {
                return this.listened;
            }

            @NotNull
            public List<? extends Value> parameters() {
                return this.parameters;
            }

            private static /* synthetic */ String jvmdowngrader$toString(MethodCall methodCall) {
                MethodCall methodCall2 = methodCall;
                return "GLSLBytecode$Value$MethodCall[" + "callingField=" + methodCall.callingField + ", " + "listened=" + methodCall.listened + ", " + "parameters=" + methodCall.parameters + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(MethodCall methodCall) {
                Object[] objectArray = new Object[]{methodCall.callingField, methodCall.listened, methodCall.parameters};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(MethodCall methodCall, Object object) {
                if (methodCall == object) {
                    return true;
                }
                if (object != null && object instanceof MethodCall) {
                    MethodCall methodCall2 = (MethodCall)object;
                    if (Objects.equals(methodCall.callingField, methodCall2.callingField) && methodCall.listened == methodCall2.listened && Objects.equals(methodCall.parameters, methodCall2.parameters)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static final class Constant
        extends J_L_Record
        implements Value {
            @NotNull
            private final String value;
            private final boolean quotations;
            public static final Constant Null = new Constant("null", false);
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public Constant(@NotNull String value) {
                this(value, true);
            }

            public Constant(int value) {
                this(Integer.toString(value), false);
            }

            public Constant(@NotNull Object object) {
                this(Objects.toString(object), false);
            }

            public Constant(@NotNull String value, boolean quotations) {
                this.value = value;
                this.quotations = quotations;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                if (this.quotations) {
                    writer.write("\"");
                    writer.write(this.value);
                    writer.write("\"");
                } else {
                    writer.write(this.value);
                }
            }

            public final String toString() {
                return Constant.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return Constant.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Constant.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public String value() {
                return this.value;
            }

            public boolean quotations() {
                return this.quotations;
            }

            private static /* synthetic */ String jvmdowngrader$toString(Constant constant) {
                Constant constant2 = constant;
                return "GLSLBytecode$Value$Constant[" + "value=" + constant.value + ", " + "quotations=" + constant.quotations + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(Constant constant) {
                Object[] objectArray = new Object[]{constant.value, constant.quotations};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(Constant constant, Object object) {
                if (constant == object) {
                    return true;
                }
                if (object != null && object instanceof Constant) {
                    Constant constant2 = (Constant)object;
                    if (Objects.equals(constant.value, constant2.value) && constant.quotations == constant2.quotations) {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static interface Statement
    extends Node {
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public static final class Return
        extends J_L_Record
        implements Statement {
            @Nullable
            private final Value value;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public Return(@Nullable Value value) {
                this.value = value;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("return");
                if (this.value != null) {
                    writer.write(" ");
                    this.value.generateSource(writer);
                }
                writer.write(";");
                writer.newLine();
            }

            public final String toString() {
                return Return.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return Return.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Return.jvmdowngrader$equals(this, o);
            }

            @Nullable
            public Value value() {
                return this.value;
            }

            private static /* synthetic */ String jvmdowngrader$toString(Return return_) {
                Return return_2 = return_;
                return "GLSLBytecode$Statement$Return[" + "value=" + return_.value + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(Return return_) {
                Object[] objectArray = new Object[]{return_.value};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(Return return_, Object object) {
                if (return_ == object) {
                    return true;
                }
                if (object != null && object instanceof Return) {
                    Return return_2 = (Return)object;
                    if (Objects.equals(return_.value, return_2.value)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static final class UpdateVariable
        extends J_L_Record
        implements Statement {
            @NotNull
            private final Value.Reference reference;
            @NotNull
            private final Value value;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public UpdateVariable(@NotNull Value.Reference reference, @NotNull Value value) {
                this.reference = reference;
                this.value = value;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.reference.generateSource(writer);
                writer.write(" = ");
                this.value.generateSource(writer);
                writer.write(";");
                writer.newLine();
            }

            public final String toString() {
                return UpdateVariable.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return UpdateVariable.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return UpdateVariable.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public Value.Reference reference() {
                return this.reference;
            }

            @NotNull
            public Value value() {
                return this.value;
            }

            private static /* synthetic */ String jvmdowngrader$toString(UpdateVariable updateVariable) {
                UpdateVariable updateVariable2 = updateVariable;
                return "GLSLBytecode$Statement$UpdateVariable[" + "reference=" + updateVariable.reference + ", " + "value=" + updateVariable.value + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(UpdateVariable updateVariable) {
                Object[] objectArray = new Object[]{updateVariable.reference, updateVariable.value};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(UpdateVariable updateVariable, Object object) {
                if (updateVariable == object) {
                    return true;
                }
                if (object != null && object instanceof UpdateVariable) {
                    UpdateVariable updateVariable2 = (UpdateVariable)object;
                    if (Objects.equals(updateVariable.reference, updateVariable2.reference) && Objects.equals(updateVariable.value, updateVariable2.value)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static final class DeclareVariable
        extends J_L_Record
        implements Statement {
            @NotNull
            private final Type type;
            @NotNull
            private final String name;
            @Nullable
            private final Value value;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public DeclareVariable(@NotNull Type type, @NotNull String name) {
                this(type, name, null);
            }

            public DeclareVariable(@NotNull Type type, @NotNull String name, @Nullable Value value) {
                this.type = type;
                this.name = name;
                this.value = value;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.type.generateSource(writer);
                writer.write(" ");
                writer.write(this.name);
                if (this.value != null) {
                    writer.write(" = ");
                    this.value.generateSource(writer);
                }
                writer.write(";");
                writer.newLine();
            }

            public final String toString() {
                return DeclareVariable.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return DeclareVariable.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return DeclareVariable.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public Type type() {
                return this.type;
            }

            @NotNull
            public String name() {
                return this.name;
            }

            @Nullable
            public Value value() {
                return this.value;
            }

            private static /* synthetic */ String jvmdowngrader$toString(DeclareVariable declareVariable) {
                DeclareVariable declareVariable2 = declareVariable;
                return "GLSLBytecode$Statement$DeclareVariable[" + "type=" + declareVariable.type + ", " + "name=" + declareVariable.name + ", " + "value=" + declareVariable.value + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(DeclareVariable declareVariable) {
                Object[] objectArray = new Object[]{declareVariable.type, declareVariable.name, declareVariable.value};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(DeclareVariable declareVariable, Object object) {
                if (declareVariable == object) {
                    return true;
                }
                if (object != null && object instanceof DeclareVariable) {
                    DeclareVariable declareVariable2 = (DeclareVariable)object;
                    if (Objects.equals(declareVariable.type, declareVariable2.type) && Objects.equals(declareVariable.name, declareVariable2.name) && Objects.equals(declareVariable.value, declareVariable2.value)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static final class If
        extends J_L_Record
        implements Statement {
            @NotNull
            private final Condition condition;
            @NotNull
            private final Body body;
            @Nullable
            private final Body elseBody;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public If(@NotNull Condition condition, @NotNull Body body) {
                this(condition, body, null);
            }

            public If(@NotNull Condition condition, @NotNull Body body, @Nullable Body elseBody) {
                this.condition = condition;
                this.body = body;
                this.elseBody = elseBody;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("if (");
                this.condition.generateSource(writer);
                writer.write(") {");
                writer.indent();
                writer.newLine();
                this.body.generateSource(writer);
                writer.unindent();
                if (this.elseBody == null) {
                    writer.write("}");
                } else {
                    writer.write("} else {");
                    writer.indent();
                    writer.newLine();
                    this.elseBody.generateSource(writer);
                    writer.unindent();
                    writer.write("}");
                }
                writer.newLine();
            }

            public final String toString() {
                return If.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return If.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return If.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public Condition condition() {
                return this.condition;
            }

            @NotNull
            public Body body() {
                return this.body;
            }

            @Nullable
            public Body elseBody() {
                return this.elseBody;
            }

            private static /* synthetic */ String jvmdowngrader$toString(If if_) {
                If if_2 = if_;
                return "GLSLBytecode$Statement$If[" + "condition=" + if_.condition + ", " + "body=" + if_.body + ", " + "elseBody=" + if_.elseBody + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(If if_) {
                Object[] objectArray = new Object[]{if_.condition, if_.body, if_.elseBody};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(If if_, Object object) {
                if (if_ == object) {
                    return true;
                }
                if (object != null && object instanceof If) {
                    If if_2 = (If)object;
                    if (Objects.equals(if_.condition, if_2.condition) && Objects.equals(if_.body, if_2.body) && Objects.equals(if_.elseBody, if_2.elseBody)) {
                        return true;
                    }
                }
                return false;
            }
        }

        public static interface Condition
        extends Statement {
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public static final class LessThanOrEqualTo
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value left;
                @NotNull
                private final Value right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public LessThanOrEqualTo(@NotNull Value left, @NotNull Value right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" <= ");
                    this.right.generateSource(writer);
                }

                public final String toString() {
                    return LessThanOrEqualTo.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return LessThanOrEqualTo.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return LessThanOrEqualTo.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value left() {
                    return this.left;
                }

                @NotNull
                public Value right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(LessThanOrEqualTo lessThanOrEqualTo) {
                    LessThanOrEqualTo lessThanOrEqualTo2 = lessThanOrEqualTo;
                    return "GLSLBytecode$Statement$Condition$LessThanOrEqualTo[" + "left=" + lessThanOrEqualTo.left + ", " + "right=" + lessThanOrEqualTo.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(LessThanOrEqualTo lessThanOrEqualTo) {
                    Object[] objectArray = new Object[]{lessThanOrEqualTo.left, lessThanOrEqualTo.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(LessThanOrEqualTo lessThanOrEqualTo, Object object) {
                    if (lessThanOrEqualTo == object) {
                        return true;
                    }
                    if (object != null && object instanceof LessThanOrEqualTo) {
                        LessThanOrEqualTo lessThanOrEqualTo2 = (LessThanOrEqualTo)object;
                        if (Objects.equals(lessThanOrEqualTo.left, lessThanOrEqualTo2.left) && Objects.equals(lessThanOrEqualTo.right, lessThanOrEqualTo2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class LessThan
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value leftValue;
                @NotNull
                private final Value rightValue;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public LessThan(@NotNull Value leftValue, @NotNull Value rightValue) {
                    this.leftValue = leftValue;
                    this.rightValue = rightValue;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.leftValue.generateSource(writer);
                    writer.write(" < ");
                    this.rightValue.generateSource(writer);
                }

                public final String toString() {
                    return LessThan.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return LessThan.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return LessThan.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value leftValue() {
                    return this.leftValue;
                }

                @NotNull
                public Value rightValue() {
                    return this.rightValue;
                }

                private static /* synthetic */ String jvmdowngrader$toString(LessThan lessThan) {
                    LessThan lessThan2 = lessThan;
                    return "GLSLBytecode$Statement$Condition$LessThan[" + "leftValue=" + lessThan.leftValue + ", " + "rightValue=" + lessThan.rightValue + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(LessThan lessThan) {
                    Object[] objectArray = new Object[]{lessThan.leftValue, lessThan.rightValue};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(LessThan lessThan, Object object) {
                    if (lessThan == object) {
                        return true;
                    }
                    if (object != null && object instanceof LessThan) {
                        LessThan lessThan2 = (LessThan)object;
                        if (Objects.equals(lessThan.leftValue, lessThan2.leftValue) && Objects.equals(lessThan.rightValue, lessThan2.rightValue)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class GreaterThanOrEqualTo
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value left;
                @NotNull
                private final Value right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public GreaterThanOrEqualTo(@NotNull Value left, @NotNull Value right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" >= ");
                    this.right.generateSource(writer);
                }

                public final String toString() {
                    return GreaterThanOrEqualTo.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return GreaterThanOrEqualTo.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return GreaterThanOrEqualTo.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value left() {
                    return this.left;
                }

                @NotNull
                public Value right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(GreaterThanOrEqualTo greaterThanOrEqualTo) {
                    GreaterThanOrEqualTo greaterThanOrEqualTo2 = greaterThanOrEqualTo;
                    return "GLSLBytecode$Statement$Condition$GreaterThanOrEqualTo[" + "left=" + greaterThanOrEqualTo.left + ", " + "right=" + greaterThanOrEqualTo.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(GreaterThanOrEqualTo greaterThanOrEqualTo) {
                    Object[] objectArray = new Object[]{greaterThanOrEqualTo.left, greaterThanOrEqualTo.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(GreaterThanOrEqualTo greaterThanOrEqualTo, Object object) {
                    if (greaterThanOrEqualTo == object) {
                        return true;
                    }
                    if (object != null && object instanceof GreaterThanOrEqualTo) {
                        GreaterThanOrEqualTo greaterThanOrEqualTo2 = (GreaterThanOrEqualTo)object;
                        if (Objects.equals(greaterThanOrEqualTo.left, greaterThanOrEqualTo2.left) && Objects.equals(greaterThanOrEqualTo.right, greaterThanOrEqualTo2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class GreaterThan
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value leftValue;
                @NotNull
                private final Value rightValue;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public GreaterThan(@NotNull Value leftValue, @NotNull Value rightValue) {
                    this.leftValue = leftValue;
                    this.rightValue = rightValue;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.leftValue.generateSource(writer);
                    writer.write(" > ");
                    this.rightValue.generateSource(writer);
                }

                public final String toString() {
                    return GreaterThan.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return GreaterThan.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return GreaterThan.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value leftValue() {
                    return this.leftValue;
                }

                @NotNull
                public Value rightValue() {
                    return this.rightValue;
                }

                private static /* synthetic */ String jvmdowngrader$toString(GreaterThan greaterThan) {
                    GreaterThan greaterThan2 = greaterThan;
                    return "GLSLBytecode$Statement$Condition$GreaterThan[" + "leftValue=" + greaterThan.leftValue + ", " + "rightValue=" + greaterThan.rightValue + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(GreaterThan greaterThan) {
                    Object[] objectArray = new Object[]{greaterThan.leftValue, greaterThan.rightValue};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(GreaterThan greaterThan, Object object) {
                    if (greaterThan == object) {
                        return true;
                    }
                    if (object != null && object instanceof GreaterThan) {
                        GreaterThan greaterThan2 = (GreaterThan)object;
                        if (Objects.equals(greaterThan.leftValue, greaterThan2.leftValue) && Objects.equals(greaterThan.rightValue, greaterThan2.rightValue)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class Or
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Condition left;
                @NotNull
                private final Condition right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public Or(@NotNull Condition left, @NotNull Condition right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write("(");
                    this.left.generateSource(writer);
                    writer.write(" || ");
                    this.right.generateSource(writer);
                    writer.write(")");
                }

                public final String toString() {
                    return Or.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return Or.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return Or.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Condition left() {
                    return this.left;
                }

                @NotNull
                public Condition right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(Or or) {
                    Or or2 = or;
                    return "GLSLBytecode$Statement$Condition$Or[" + "left=" + or.left + ", " + "right=" + or.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(Or or) {
                    Object[] objectArray = new Object[]{or.left, or.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(Or or, Object object) {
                    if (or == object) {
                        return true;
                    }
                    if (object != null && object instanceof Or) {
                        Or or2 = (Or)object;
                        if (Objects.equals(or.left, or2.left) && Objects.equals(or.right, or2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class And
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Condition left;
                @NotNull
                private final Condition right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public And(@NotNull Condition left, @NotNull Condition right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" && ");
                    this.right.generateSource(writer);
                }

                public final String toString() {
                    return And.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return And.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return And.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Condition left() {
                    return this.left;
                }

                @NotNull
                public Condition right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(And and) {
                    And and2 = and;
                    return "GLSLBytecode$Statement$Condition$And[" + "left=" + and.left + ", " + "right=" + and.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(And and) {
                    Object[] objectArray = new Object[]{and.left, and.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(And and, Object object) {
                    if (and == object) {
                        return true;
                    }
                    if (object != null && object instanceof And) {
                        And and2 = (And)object;
                        if (Objects.equals(and.left, and2.left) && Objects.equals(and.right, and2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class NotEqualTo
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value left;
                @NotNull
                private final Value right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public NotEqualTo(@NotNull Value left, @NotNull Value right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" != ");
                    this.right.generateSource(writer);
                }

                public final String toString() {
                    return NotEqualTo.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return NotEqualTo.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return NotEqualTo.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value left() {
                    return this.left;
                }

                @NotNull
                public Value right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(NotEqualTo notEqualTo) {
                    NotEqualTo notEqualTo2 = notEqualTo;
                    return "GLSLBytecode$Statement$Condition$NotEqualTo[" + "left=" + notEqualTo.left + ", " + "right=" + notEqualTo.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(NotEqualTo notEqualTo) {
                    Object[] objectArray = new Object[]{notEqualTo.left, notEqualTo.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(NotEqualTo notEqualTo, Object object) {
                    if (notEqualTo == object) {
                        return true;
                    }
                    if (object != null && object instanceof NotEqualTo) {
                        NotEqualTo notEqualTo2 = (NotEqualTo)object;
                        if (Objects.equals(notEqualTo.left, notEqualTo2.left) && Objects.equals(notEqualTo.right, notEqualTo2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class Not
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Condition condition;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public Not(@NotNull Condition condition) {
                    this.condition = condition;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write("!(");
                    this.condition.generateSource(writer);
                    writer.write(")");
                }

                public final String toString() {
                    return Not.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return Not.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return Not.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Condition condition() {
                    return this.condition;
                }

                private static /* synthetic */ String jvmdowngrader$toString(Not not) {
                    Not not2 = not;
                    return "GLSLBytecode$Statement$Condition$Not[" + "condition=" + not.condition + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(Not not) {
                    Object[] objectArray = new Object[]{not.condition};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(Not not, Object object) {
                    if (not == object) {
                        return true;
                    }
                    if (object != null && object instanceof Not) {
                        Not not2 = (Not)object;
                        if (Objects.equals(not.condition, not2.condition)) {
                            return true;
                        }
                    }
                    return false;
                }
            }

            public static final class EqualTo
            extends J_L_Record
            implements Condition {
                @NotNull
                private final Value left;
                @NotNull
                private final Value right;
                public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

                public EqualTo(@NotNull Value left, @NotNull Value right) {
                    this.left = left;
                    this.right = right;
                }

                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" == ");
                    this.right.generateSource(writer);
                }

                public final String toString() {
                    return EqualTo.jvmdowngrader$toString(this);
                }

                public final int hashCode() {
                    return EqualTo.jvmdowngrader$hashCode(this);
                }

                public final boolean equals(Object o) {
                    return EqualTo.jvmdowngrader$equals(this, o);
                }

                @NotNull
                public Value left() {
                    return this.left;
                }

                @NotNull
                public Value right() {
                    return this.right;
                }

                private static /* synthetic */ String jvmdowngrader$toString(EqualTo equalTo) {
                    EqualTo equalTo2 = equalTo;
                    return "GLSLBytecode$Statement$Condition$EqualTo[" + "left=" + equalTo.left + ", " + "right=" + equalTo.right + "]";
                }

                private static /* synthetic */ int jvmdowngrader$hashCode(EqualTo equalTo) {
                    Object[] objectArray = new Object[]{equalTo.left, equalTo.right};
                    return Arrays.hashCode(objectArray);
                }

                private static /* synthetic */ boolean jvmdowngrader$equals(EqualTo equalTo, Object object) {
                    if (equalTo == object) {
                        return true;
                    }
                    if (object != null && object instanceof EqualTo) {
                        EqualTo equalTo2 = (EqualTo)object;
                        if (Objects.equals(equalTo.left, equalTo2.left) && Objects.equals(equalTo.right, equalTo2.right)) {
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
    }

    public static final class Body
    extends J_L_Record
    implements Node {
        @NotNull
        private final @NotNull List<@NotNull Statement> statements;
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public Body(Statement ... statements) {
            this(J_U_List.of((Object[])statements));
        }

        public Body(@NotNull @NotNull List<@NotNull Statement> statements) {
            this.statements = statements;
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            for (Statement statement : this.statements) {
                statement.generateSource(writer);
            }
        }

        public final String toString() {
            return Body.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Body.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Body.jvmdowngrader$equals(this, o);
        }

        @NotNull
        public @NotNull List<@NotNull Statement> statements() {
            return this.statements;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Body body) {
            Body body2 = body;
            return "GLSLBytecode$Body[" + "statements=" + body.statements + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Body body) {
            Object[] objectArray = new Object[]{body.statements};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Body body, Object object) {
            if (body == object) {
                return true;
            }
            if (object != null && object instanceof Body) {
                Body body2 = (Body)object;
                if (Objects.equals(body.statements, body2.statements)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Method
    extends J_L_Record
    implements TopLevelNode {
        @NotNull
        private final Type returnType;
        @NotNull
        private final String name;
        @NotNull
        private final @NotNull List<@NotNull Parameter> parameters;
        @NotNull
        private final Body body;
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public Method(@NotNull Type returnType, @NotNull String name, @NotNull @NotNull List<@NotNull Parameter> parameters, @NotNull Body body) {
            this.returnType = returnType;
            this.name = name;
            this.parameters = parameters;
            this.body = body;
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            this.returnType.generateSource(writer);
            writer.write(" ");
            writer.write(this.name);
            writer.write("(");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                this.parameters.get(i).generateSource(writer);
            }
            writer.write(") {");
            writer.indent();
            writer.newLine();
            this.body.generateSource(writer);
            writer.unindent();
            writer.write("}");
            writer.newLine();
        }

        public final String toString() {
            return Method.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Method.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Method.jvmdowngrader$equals(this, o);
        }

        @NotNull
        public Type returnType() {
            return this.returnType;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public @NotNull List<@NotNull Parameter> parameters() {
            return this.parameters;
        }

        @NotNull
        public Body body() {
            return this.body;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Method method) {
            Method method2 = method;
            return "GLSLBytecode$Method[" + "returnType=" + method.returnType + ", " + "name=" + method.name + ", " + "parameters=" + method.parameters + ", " + "body=" + method.body + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Method method) {
            Object[] objectArray = new Object[]{method.returnType, method.name, method.parameters, method.body};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Method method, Object object) {
            if (method == object) {
                return true;
            }
            if (object != null && object instanceof Method) {
                Method method2 = (Method)object;
                if (Objects.equals(method.returnType, method2.returnType) && Objects.equals(method.name, method2.name) && Objects.equals(method.parameters, method2.parameters) && Objects.equals(method.body, method2.body)) {
                    return true;
                }
            }
            return false;
        }

        public static final class Parameter
        extends J_L_Record
        implements Node {
            @NotNull
            private final Type type;
            @NotNull
            private final String name;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            public Parameter(@NotNull Type type, @NotNull String name) {
                this.type = type;
                this.name = name;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.type.generateSource(writer);
                writer.write(" ");
                writer.write(this.name);
            }

            public final String toString() {
                return Parameter.jvmdowngrader$toString(this);
            }

            public final int hashCode() {
                return Parameter.jvmdowngrader$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Parameter.jvmdowngrader$equals(this, o);
            }

            @NotNull
            public Type type() {
                return this.type;
            }

            @NotNull
            public String name() {
                return this.name;
            }

            private static /* synthetic */ String jvmdowngrader$toString(Parameter parameter) {
                Parameter parameter2 = parameter;
                return "GLSLBytecode$Method$Parameter[" + "type=" + parameter.type + ", " + "name=" + parameter.name + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode(Parameter parameter) {
                Object[] objectArray = new Object[]{parameter.type, parameter.name};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals(Parameter parameter, Object object) {
                if (parameter == object) {
                    return true;
                }
                if (object != null && object instanceof Parameter) {
                    Parameter parameter2 = (Parameter)object;
                    if (Objects.equals(parameter.type, parameter2.type) && Objects.equals(parameter.name, parameter2.name)) {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static final class Field
    extends J_L_Record
    implements TopLevelNode {
        @Nullable
        private final Type fieldType;
        @NotNull
        private final String name;
        @NotNull
        private final org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode$Type valueType;
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public Field(@Nullable Type fieldType, @NotNull String name, @NotNull org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode$Type valueType) {
            this.fieldType = fieldType;
            this.name = name;
            this.valueType = valueType;
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            if (this.fieldType != null) {
                this.fieldType.generateSource(writer);
                writer.write(" ");
            }
            this.valueType.generateSource(writer);
            writer.write(" ");
            writer.write(this.name);
            writer.write(";\n");
        }

        public final String toString() {
            return Field.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Field.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Field.jvmdowngrader$equals(this, o);
        }

        @Nullable
        public Type fieldType() {
            return this.fieldType;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode$Type valueType() {
            return this.valueType;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Field field) {
            Field field2 = field;
            return "GLSLBytecode$Field[" + "fieldType=" + field.fieldType + ", " + "name=" + field.name + ", " + "valueType=" + field.valueType + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Field field) {
            Object[] objectArray = new Object[]{field.fieldType, field.name, field.valueType};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Field field, Object object) {
            if (field == object) {
                return true;
            }
            if (object != null && object instanceof Field) {
                Field field2 = (Field)object;
                if (Objects.equals(field.fieldType, field2.fieldType) && Objects.equals(field.name, field2.name) && Objects.equals(field.valueType, field2.valueType)) {
                    return true;
                }
            }
            return false;
        }

        public static enum Type implements Node
        {
            UNIFORM("uniform"),
            IN("in"),
            OUT("out");

            private final String display;
            public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

            private Type(String display) {
                this.display = display;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write(this.display);
            }
        }
    }

    public static final class Root
    extends J_L_Record
    implements Node {
        private final int version;
        @NotNull
        private final @NotNull List<? extends @NotNull TopLevelNode> nodes;
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public Root(int version, TopLevelNode ... nodes) {
            this(version, J_U_List.of((Object[])nodes));
        }

        public Root(int version, Collection<? extends TopLevelNode> ... nodeCollections) {
            this(version, J_U_S_Stream.toList(Stream.of(nodeCollections).flatMap(Collection::stream)));
        }

        public Root(int version, @NotNull @NotNull List<? extends @NotNull TopLevelNode> nodes) {
            this.version = version;
            this.nodes = nodes;
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            writer.write(Root.jvmdowngrader$concat(this.version));
            writer.write("// Generated by JLSL\n");
            writer.write("\n");
            for (TopLevelNode topLevelNode : this.nodes) {
                topLevelNode.generateSource(writer);
            }
        }

        public final String toString() {
            return Root.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Root.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Root.jvmdowngrader$equals(this, o);
        }

        public int version() {
            return this.version;
        }

        @NotNull
        public @NotNull List<? extends @NotNull TopLevelNode> nodes() {
            return this.nodes;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Root root) {
            Root root2 = root;
            return "GLSLBytecode$Root[" + "version=" + root.version + ", " + "nodes=" + root.nodes + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Root root) {
            Object[] objectArray = new Object[]{root.version, root.nodes};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Root root, Object object) {
            if (root == object) {
                return true;
            }
            if (object != null && object instanceof Root) {
                Root root2 = (Root)object;
                if (root.version == root2.version && Objects.equals(root.nodes, root2.nodes)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ String jvmdowngrader$concat(int n) {
            return "#version " + n + " core\n";
        }
    }

    public static interface Node {
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/glslbytecode/GLSLBytecode";

        public void generateSource(@NotNull IndentedStringWriter var1);

        @NotNull
        default public String generateSource(@NotNull String indent) {
            IndentedStringWriter writer = new IndentedStringWriter(indent);
            this.generateSource(writer);
            return writer.toString();
        }
    }
}

