/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jglrxavpok.jlsl.CodeDecoder;
import org.jglrxavpok.jlsl.JLSLException;
import org.jglrxavpok.jlsl.fragments.AccessPolicy;
import org.jglrxavpok.jlsl.fragments.AddFragment;
import org.jglrxavpok.jlsl.fragments.AndFragment;
import org.jglrxavpok.jlsl.fragments.AnnotationFragment;
import org.jglrxavpok.jlsl.fragments.ArrayOfArrayLoadFragment;
import org.jglrxavpok.jlsl.fragments.ArrayStoreFragment;
import org.jglrxavpok.jlsl.fragments.CastFragment;
import org.jglrxavpok.jlsl.fragments.CodeFragment;
import org.jglrxavpok.jlsl.fragments.CompareFragment;
import org.jglrxavpok.jlsl.fragments.DivFragment;
import org.jglrxavpok.jlsl.fragments.DuplicateFragment;
import org.jglrxavpok.jlsl.fragments.ElseStatementFragment;
import org.jglrxavpok.jlsl.fragments.EndOfBlockFragment;
import org.jglrxavpok.jlsl.fragments.EndOfMethodFragment;
import org.jglrxavpok.jlsl.fragments.EqualCheckFragment;
import org.jglrxavpok.jlsl.fragments.FieldFragment;
import org.jglrxavpok.jlsl.fragments.GetFieldFragment;
import org.jglrxavpok.jlsl.fragments.IfNotStatementFragment;
import org.jglrxavpok.jlsl.fragments.IfStatementFragment;
import org.jglrxavpok.jlsl.fragments.IntPushFragment;
import org.jglrxavpok.jlsl.fragments.LdcFragment;
import org.jglrxavpok.jlsl.fragments.LeftShiftFragment;
import org.jglrxavpok.jlsl.fragments.LineNumberFragment;
import org.jglrxavpok.jlsl.fragments.LoadConstantFragment;
import org.jglrxavpok.jlsl.fragments.LoadVariableFragment;
import org.jglrxavpok.jlsl.fragments.MethodCallFragment;
import org.jglrxavpok.jlsl.fragments.ModFragment;
import org.jglrxavpok.jlsl.fragments.MulFragment;
import org.jglrxavpok.jlsl.fragments.NewArrayFragment;
import org.jglrxavpok.jlsl.fragments.NewClassFragment;
import org.jglrxavpok.jlsl.fragments.NewInstanceFragment;
import org.jglrxavpok.jlsl.fragments.NewMultiArrayFragment;
import org.jglrxavpok.jlsl.fragments.NewPrimitiveArrayFragment;
import org.jglrxavpok.jlsl.fragments.NotEqualCheckFragment;
import org.jglrxavpok.jlsl.fragments.OrFragment;
import org.jglrxavpok.jlsl.fragments.PopFragment;
import org.jglrxavpok.jlsl.fragments.PutFieldFragment;
import org.jglrxavpok.jlsl.fragments.ReturnFragment;
import org.jglrxavpok.jlsl.fragments.ReturnValueFragment;
import org.jglrxavpok.jlsl.fragments.RightShiftFragment;
import org.jglrxavpok.jlsl.fragments.StartOfMethodFragment;
import org.jglrxavpok.jlsl.fragments.StoreVariableFragment;
import org.jglrxavpok.jlsl.fragments.SubFragment;
import org.jglrxavpok.jlsl.fragments.XorFragment;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class BytecodeDecoder
extends CodeDecoder {
    public static boolean DEBUG = false;
    private boolean instructionsFromInterfaces = false;

    public BytecodeDecoder addInstructionsFromInterfaces(boolean add) {
        this.instructionsFromInterfaces = add;
        return this;
    }

    public void handleClass(ClassNode classNode, List<CodeFragment> out) {
        NewClassFragment classFragment = new NewClassFragment();
        classFragment.className = classNode.name.replace("/", ".").replace("$", ".");
        classFragment.superclass = classNode.superName.replace("/", ".").replace("$", ".");
        classFragment.access = new AccessPolicy(classNode.access);
        if (classNode.sourceFile != null) {
            classFragment.sourceFile = classNode.sourceFile;
        }
        classFragment.classVersion = classNode.version;
        List interfaces = classNode.interfaces;
        classFragment.interfaces = interfaces.toArray(new String[0]);
        if (this.instructionsFromInterfaces) {
            for (String interfaceInst : interfaces) {
                ArrayList<CodeFragment> fragments = new ArrayList<CodeFragment>();
                this.handleClass(interfaceInst.replace("/", "."), fragments);
                out.addAll(fragments);
            }
        }
        out.add(classFragment);
        List methodNodes = classNode.methods;
        List fieldNodes = classNode.fields;
        List list = classNode.visibleAnnotations;
        if (list != null) {
            for (AnnotationNode annotNode : list) {
                AnnotationFragment annotFragment = BytecodeDecoder.createFromNode(annotNode);
                classFragment.addChild(annotFragment);
            }
        }
        for (FieldNode field : fieldNodes) {
            String name = field.name;
            String type = BytecodeDecoder.typesFromDesc(field.desc)[0];
            FieldFragment fieldFragment = new FieldFragment();
            fieldFragment.name = name;
            fieldFragment.type = type;
            fieldFragment.initialValue = field.value;
            fieldFragment.access = new AccessPolicy(field.access);
            List annotations = field.visibleAnnotations;
            if (annotations != null) {
                Iterator iterator = annotations.iterator();
                while (iterator.hasNext()) {
                    String[] annotNode = (String[])iterator.next();
                    AnnotationFragment annotFragment = BytecodeDecoder.createFromNode((AnnotationNode)annotNode);
                    fieldFragment.addChild(annotFragment);
                }
            }
            out.add(fieldFragment);
        }
        Collections.sort(methodNodes, new Comparator<MethodNode>(){

            @Override
            public int compare(MethodNode arg0, MethodNode arg1) {
                if (arg0.name.equals("main")) {
                    return 1;
                }
                if (arg1.name.equals("main")) {
                    return -1;
                }
                return 0;
            }
        });
        for (MethodNode node : methodNodes) {
            List localVariables = node.localVariables;
            StartOfMethodFragment startOfMethodFragment = new StartOfMethodFragment();
            startOfMethodFragment.access = new AccessPolicy(node.access);
            startOfMethodFragment.name = node.name;
            startOfMethodFragment.owner = classNode.name.replace("/", ".");
            startOfMethodFragment.returnType = BytecodeDecoder.typesFromDesc(node.desc.substring(node.desc.indexOf(")") + 1))[0];
            ArrayList<String> localNames = new ArrayList<String>();
            for (LocalVariableNode var : localVariables) {
                startOfMethodFragment.varNameMap.put(var.index, var.name);
                startOfMethodFragment.varTypeMap.put(var.index, BytecodeDecoder.typesFromDesc(var.desc)[0]);
                startOfMethodFragment.varName2TypeMap.put(var.name, BytecodeDecoder.typesFromDesc(var.desc)[0]);
                if (var.index == 0 && !startOfMethodFragment.access.isStatic()) continue;
                localNames.add(var.name);
            }
            String[] argsTypes = BytecodeDecoder.typesFromDesc(node.desc.substring(node.desc.indexOf(40) + 1, node.desc.indexOf(41)));
            int argIndex = 0;
            for (String argType : argsTypes) {
                startOfMethodFragment.argumentsTypes.add(argType);
                String name = localNames.isEmpty() ? "var" + argIndex : (String)localNames.get(argIndex);
                startOfMethodFragment.argumentsNames.add(name);
                ++argIndex;
            }
            List annots = node.visibleAnnotations;
            if (node.visibleAnnotations != null) {
                for (AnnotationNode annotNode : annots) {
                    startOfMethodFragment.addChild(BytecodeDecoder.createFromNode(annotNode));
                }
            }
            out.add(startOfMethodFragment);
            BytecodeDecoder.addAnnotFragments(startOfMethodFragment.owner, node.name, node.desc, startOfMethodFragment);
            BytecodeDecoder.handleMethodNode(node, startOfMethodFragment.varTypeMap, startOfMethodFragment.varNameMap, out);
            EndOfMethodFragment endOfMethodFragment = new EndOfMethodFragment();
            endOfMethodFragment.access = startOfMethodFragment.access;
            endOfMethodFragment.name = startOfMethodFragment.name;
            endOfMethodFragment.owner = startOfMethodFragment.owner;
            endOfMethodFragment.argumentsNames = startOfMethodFragment.argumentsNames;
            endOfMethodFragment.argumentsTypes = startOfMethodFragment.argumentsTypes;
            endOfMethodFragment.returnType = startOfMethodFragment.returnType;
            endOfMethodFragment.varNameMap = startOfMethodFragment.varNameMap;
            endOfMethodFragment.varTypeMap = startOfMethodFragment.varTypeMap;
            endOfMethodFragment.varName2TypeMap = startOfMethodFragment.varName2TypeMap;
            endOfMethodFragment.getChildren().addAll(startOfMethodFragment.getChildren());
            BytecodeDecoder.addAnnotFragments(endOfMethodFragment.owner, node.name, node.desc, endOfMethodFragment);
            out.add(endOfMethodFragment);
        }
    }

    @Override
    public void handleClass(Object data, List<CodeFragment> out) {
        if (data instanceof ClassNode) {
            this.handleClass((ClassNode)data, out);
            return;
        }
        if (data == null) {
            return;
        }
        try {
            ClassReader reader;
            if (data instanceof byte[]) {
                reader = new ClassReader((byte[])data);
            } else if (data instanceof InputStream) {
                reader = new ClassReader((InputStream)data);
            } else {
                if (data instanceof String) {
                    this.handleClass(Class.forName((String)data), out);
                    return;
                }
                if (data instanceof Class) {
                    Class clazz = (Class)data;
                    ClassLoader loader = clazz.getClassLoader();
                    reader = new ClassReader(loader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class"));
                } else {
                    throw new JLSLException("Invalid type: " + data.getClass().getCanonicalName());
                }
            }
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            if (DEBUG) {
                reader.accept((ClassVisitor)new TraceClassVisitor(new PrintWriter(System.out)), 0);
            }
            this.handleClass(classNode, out);
        }
        catch (Exception e) {
            throw new JLSLException(e);
        }
    }

    private static AnnotationFragment createFromNode(AnnotationNode annotNode) {
        AnnotationFragment annotFragment = new AnnotationFragment();
        annotFragment.name = BytecodeDecoder.typesFromDesc(annotNode.desc)[0].replace("/", ".").replace("$", ".");
        List values = annotNode.values;
        if (values != null) {
            for (int index = 0; index < values.size(); index += 2) {
                String key = (String)values.get(index);
                Object value = values.get(index + 1);
                annotFragment.values.put(key, value);
            }
        }
        return annotFragment;
    }

    private static void handleMethodNode(MethodNode node, HashMap<Integer, String> varTypeMap, HashMap<Integer, String> varNameMap, List<CodeFragment> out) {
        int lastFrameType = 0;
        int frames = 0;
        int framesToSkip = 0;
        Stack<LabelNode> toJump = new Stack<LabelNode>();
        Stack<Label> gotos = new Stack<Label>();
        Stack<Label> ifs = new Stack<Label>();
        InsnList instructions = node.instructions;
        Label currentLabel = null;
        for (int index = 0; index < instructions.size(); ++index) {
            MethodCallFragment methodFragment;
            AbstractInsnNode ainsnNode = instructions.get(index);
            if (ainsnNode.getType() == 0) {
                InsnNode insnNode = (InsnNode)ainsnNode;
                if (insnNode.getOpcode() == 3) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 0;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 4) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 1;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 5) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 2;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 6) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 3;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 7) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 4;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 8) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 5;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 14) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 0.0;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 15) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = 1.0;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 11) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = Float.valueOf(0.0f);
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 12) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = Float.valueOf(1.0f);
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 13) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = Float.valueOf(2.0f);
                    out.add(loadConstantFragment);
                    continue;
                }
                if (insnNode.getOpcode() == 1) {
                    LoadConstantFragment loadConstantFragment = new LoadConstantFragment();
                    loadConstantFragment.value = null;
                    out.add(loadConstantFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 173 || ainsnNode.getOpcode() == 175 || ainsnNode.getOpcode() == 174 || ainsnNode.getOpcode() == 172 || ainsnNode.getOpcode() == 176) {
                    ReturnValueFragment returnFrag = new ReturnValueFragment();
                    out.add(returnFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 97 || ainsnNode.getOpcode() == 99 || ainsnNode.getOpcode() == 98 || ainsnNode.getOpcode() == 96) {
                    out.add(new AddFragment());
                    continue;
                }
                if (ainsnNode.getOpcode() == 101 || ainsnNode.getOpcode() == 103 || ainsnNode.getOpcode() == 102 || ainsnNode.getOpcode() == 100) {
                    out.add(new SubFragment());
                    continue;
                }
                if (ainsnNode.getOpcode() == 105 || ainsnNode.getOpcode() == 107 || ainsnNode.getOpcode() == 106 || ainsnNode.getOpcode() == 104) {
                    out.add(new MulFragment());
                    continue;
                }
                if (ainsnNode.getOpcode() == 109 || ainsnNode.getOpcode() == 111 || ainsnNode.getOpcode() == 110 || ainsnNode.getOpcode() == 108) {
                    out.add(new DivFragment());
                    continue;
                }
                if (ainsnNode.getOpcode() == 115 || ainsnNode.getOpcode() == 112 || ainsnNode.getOpcode() == 114 || ainsnNode.getOpcode() == 113) {
                    out.add(new ModFragment());
                    continue;
                }
                if (ainsnNode.getOpcode() == 142) {
                    CastFragment cast = new CastFragment();
                    cast.from = "double";
                    cast.to = "int";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 135) {
                    CastFragment cast = new CastFragment();
                    cast.from = "int";
                    cast.to = "double";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 134) {
                    CastFragment cast = new CastFragment();
                    cast.from = "int";
                    cast.to = "float";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 133) {
                    CastFragment cast = new CastFragment();
                    cast.from = "int";
                    cast.to = "long";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 146) {
                    CastFragment cast = new CastFragment();
                    cast.from = "int";
                    cast.to = "char";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 139) {
                    CastFragment cast = new CastFragment();
                    cast.from = "float";
                    cast.to = "int";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 141) {
                    CastFragment cast = new CastFragment();
                    cast.from = "float";
                    cast.to = "double";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 140) {
                    CastFragment cast = new CastFragment();
                    cast.from = "float";
                    cast.to = "long";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 138) {
                    CastFragment cast = new CastFragment();
                    cast.from = "long";
                    cast.to = "double";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 136) {
                    CastFragment cast = new CastFragment();
                    cast.from = "long";
                    cast.to = "int";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 137) {
                    CastFragment cast = new CastFragment();
                    cast.from = "long";
                    cast.to = "float";
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() == 122) {
                    RightShiftFragment shrFragment = new RightShiftFragment();
                    shrFragment.signed = true;
                    shrFragment.type = "int";
                    out.add(shrFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 124) {
                    RightShiftFragment shrFragment = new RightShiftFragment();
                    shrFragment.signed = false;
                    shrFragment.type = "int";
                    out.add(shrFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 123) {
                    RightShiftFragment shrFragment = new RightShiftFragment();
                    shrFragment.signed = true;
                    shrFragment.type = "long";
                    out.add(shrFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 125) {
                    RightShiftFragment shrFragment = new RightShiftFragment();
                    shrFragment.signed = false;
                    shrFragment.type = "long";
                    out.add(shrFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 120) {
                    LeftShiftFragment shlFragment = new LeftShiftFragment();
                    shlFragment.signed = true;
                    shlFragment.type = "int";
                    out.add(shlFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 121) {
                    LeftShiftFragment shlFragment = new LeftShiftFragment();
                    shlFragment.type = "long";
                    shlFragment.signed = true;
                    out.add(shlFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 126) {
                    AndFragment andFragment = new AndFragment();
                    andFragment.type = "int";
                    out.add(andFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 127) {
                    AndFragment andFragment = new AndFragment();
                    andFragment.type = "long";
                    out.add(andFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 128) {
                    OrFragment orFragment = new OrFragment();
                    orFragment.type = "int";
                    out.add(orFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 129) {
                    OrFragment orFragment = new OrFragment();
                    orFragment.type = "long";
                    out.add(orFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 130) {
                    XorFragment xorFragment = new XorFragment();
                    xorFragment.type = "int";
                    out.add(xorFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 131) {
                    XorFragment xorFragment = new XorFragment();
                    xorFragment.type = "long";
                    out.add(xorFragment);
                    continue;
                }
                if (ainsnNode.getOpcode() == 87) {
                    PopFragment popFrag = new PopFragment();
                    out.add(popFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 177) {
                    ReturnFragment returnFrag = new ReturnFragment();
                    out.add(returnFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 89) {
                    DuplicateFragment duplicate = new DuplicateFragment();
                    duplicate.wait = 1;
                    out.add(duplicate);
                    continue;
                }
                if (ainsnNode.getOpcode() == 93) {
                    DuplicateFragment duplicate = new DuplicateFragment();
                    duplicate.wait = 1;
                    out.add(duplicate);
                    continue;
                }
                if (ainsnNode.getOpcode() == 152 || ainsnNode.getOpcode() == 150) {
                    CompareFragment compareFrag = new CompareFragment();
                    compareFrag.inferior = true;
                    out.add(compareFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 151 || ainsnNode.getOpcode() == 149) {
                    if (instructions.get(index + 1).getOpcode() == 153) {
                        NotEqualCheckFragment notEqualFrag = new NotEqualCheckFragment();
                        out.add(notEqualFrag);
                        continue;
                    }
                    if (instructions.get(index + 1).getOpcode() == 154) {
                        NotEqualCheckFragment notEqualFrag = new NotEqualCheckFragment();
                        out.add(notEqualFrag);
                        continue;
                    }
                    CompareFragment compareFrag = new CompareFragment();
                    compareFrag.inferior = false;
                    out.add(compareFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 83 || ainsnNode.getOpcode() == 79 || ainsnNode.getOpcode() == 84 || ainsnNode.getOpcode() == 80 || ainsnNode.getOpcode() == 86 || ainsnNode.getOpcode() == 81 || ainsnNode.getOpcode() == 82 || ainsnNode.getOpcode() == 85) {
                    ArrayStoreFragment storeFrag = new ArrayStoreFragment();
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() != 50) continue;
                ArrayOfArrayLoadFragment loadFrag = new ArrayOfArrayLoadFragment();
                out.add(loadFrag);
                continue;
            }
            if (ainsnNode.getType() == 8) {
                LabelNode labelNode = (LabelNode)ainsnNode;
                currentLabel = labelNode.getLabel();
                if (toJump.isEmpty() || !labelNode.getLabel().equals(((LabelNode)toJump.peek()).getLabel())) continue;
                while (!toJump.isEmpty() && ((LabelNode)toJump.pop()).getLabel().equals(labelNode.getLabel())) {
                    if (gotos.isEmpty()) continue;
                    while (gotos.contains(currentLabel)) {
                        if (frames > 0) {
                            EndOfBlockFragment endOfBlockFrag = new EndOfBlockFragment();
                            out.add(endOfBlockFrag);
                            --frames;
                        }
                        gotos.remove(currentLabel);
                    }
                }
                continue;
            }
            if (ainsnNode.getType() == 14) {
                FrameNode frameNode = (FrameNode)ainsnNode;
                if (framesToSkip > 0) {
                    --framesToSkip;
                } else if (frames != 0) {
                    boolean a = !ifs.isEmpty() && ifs.contains(currentLabel);
                    boolean b = gotos.isEmpty() || !gotos.contains(currentLabel);
                    int nbr = 0;
                    if (a || b) {
                        while (ifs.contains(currentLabel)) {
                            ++nbr;
                            ifs.remove(currentLabel);
                        }
                    }
                    for (int j = 0; j < nbr; ++j) {
                        EndOfBlockFragment end = new EndOfBlockFragment();
                        out.add(end);
                        --frames;
                    }
                }
                lastFrameType = frameNode.type;
                continue;
            }
            if (ainsnNode.getType() == 7) {
                StoreVariableFragment storeFrag;
                JumpInsnNode jumpNode = (JumpInsnNode)ainsnNode;
                if (jumpNode.getOpcode() == 153) {
                    if (instructions.get(index - 1).getOpcode() == 21 && instructions.get(index + 1).getOpcode() == 21 && instructions.get(index + 2).getOpcode() == 153 && instructions.get(index + 3).getOpcode() == 4 && instructions.get(index + 4).getOpcode() == 167 && instructions.get(index + 5).getType() == 8 && instructions.get(index + 6).getType() == 14 && instructions.get(index + 7).getOpcode() == 3 && instructions.get(index + 8).getType() == 8 && instructions.get(index + 9).getType() == 14 && instructions.get(index + 10).getOpcode() == 54) {
                        int operand = ((VarInsnNode)instructions.get((int)(index + 1))).var;
                        LoadVariableFragment loadFrag = new LoadVariableFragment();
                        loadFrag.variableName = varNameMap.get(operand);
                        loadFrag.variableIndex = operand;
                        out.add(loadFrag);
                        AndFragment andFrag = new AndFragment();
                        andFrag.isDouble = true;
                        out.add(andFrag);
                        int operand1 = ((VarInsnNode)instructions.get((int)(index + 10))).var;
                        storeFrag = new StoreVariableFragment();
                        storeFrag.variableName = varNameMap.get(operand1);
                        storeFrag.variableIndex = operand1;
                        storeFrag.variableType = "int";
                        out.add(storeFrag);
                        index += 10;
                        continue;
                    }
                    IfStatementFragment ifFrag = new IfStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (!(jumpNode.getOpcode() != 159 || instructions.get(index + 1).getOpcode() != 4 || instructions.get(index + 2).getOpcode() != 172 && instructions.get(index + 2).getOpcode() != 54 || instructions.get(index + 3).getType() != 8 || instructions.get(index + 4).getType() != 14 || instructions.get(index + 5).getOpcode() != 3 || instructions.get(index + 6).getOpcode() != 172 && instructions.get(index + 2).getOpcode() != 54)) {
                    NotEqualCheckFragment notEqualFrag = new NotEqualCheckFragment();
                    out.add(notEqualFrag);
                    index += 5;
                    continue;
                }
                if (!(jumpNode.getOpcode() != 160 || instructions.get(index + 1).getOpcode() != 4 || instructions.get(index + 2).getOpcode() != 172 && instructions.get(index + 2).getOpcode() != 54 || instructions.get(index + 3).getType() != 8 || instructions.get(index + 4).getType() != 14 || instructions.get(index + 5).getOpcode() != 3 || instructions.get(index + 6).getOpcode() != 172 && instructions.get(index + 2).getOpcode() != 54)) {
                    EqualCheckFragment equalFrag = new EqualCheckFragment();
                    out.add(equalFrag);
                    index += 5;
                    continue;
                }
                if (jumpNode.getOpcode() == 154) {
                    if (instructions.get(index - 1).getOpcode() == 21 && instructions.get(index + 1).getOpcode() == 21 && instructions.get(index + 2).getOpcode() == 154 && instructions.get(index + 3).getOpcode() == 3 && instructions.get(index + 4).getOpcode() == 167 && instructions.get(index + 5).getType() == 8 && instructions.get(index + 6).getType() == 14 && instructions.get(index + 7).getOpcode() == 4 && instructions.get(index + 8).getType() == 8 && instructions.get(index + 9).getType() == 14 && instructions.get(index + 10).getOpcode() == 54) {
                        int operand = ((VarInsnNode)instructions.get((int)(index + 1))).var;
                        LoadVariableFragment loadFrag = new LoadVariableFragment();
                        loadFrag.variableName = varNameMap.get(operand);
                        loadFrag.variableIndex = operand;
                        out.add(loadFrag);
                        OrFragment orFrag = new OrFragment();
                        orFrag.isDouble = true;
                        out.add(orFrag);
                        int operand1 = ((VarInsnNode)instructions.get((int)(index + 10))).var;
                        storeFrag = new StoreVariableFragment();
                        storeFrag.variableName = varNameMap.get(operand1);
                        storeFrag.variableIndex = operand1;
                        storeFrag.variableType = "int";
                        out.add(storeFrag);
                        index += 10;
                        continue;
                    }
                    IfNotStatementFragment ifFrag = new IfNotStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (jumpNode.getOpcode() == 159) {
                    out.add(new NotEqualCheckFragment());
                    IfStatementFragment ifFrag = new IfStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (jumpNode.getOpcode() == 160) {
                    out.add(new EqualCheckFragment());
                    IfStatementFragment ifFrag = new IfStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (jumpNode.getOpcode() == 156) {
                    IfStatementFragment ifFrag = new IfStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (jumpNode.getOpcode() == 158) {
                    IfStatementFragment ifFrag = new IfStatementFragment();
                    ++frames;
                    ifs.push(jumpNode.label.getLabel());
                    ifFrag.toJump = jumpNode.label.getLabel().toString();
                    out.add(ifFrag);
                    toJump.push(jumpNode.label);
                    continue;
                }
                if (jumpNode.getOpcode() != 167) continue;
                toJump.push(jumpNode.label);
                gotos.push(jumpNode.label.getLabel());
                if (instructions.get(index - 1) instanceof LineNumberNode && lastFrameType == 3) {
                    EndOfBlockFragment end = new EndOfBlockFragment();
                    --frames;
                    out.add(end);
                }
                EndOfBlockFragment end = new EndOfBlockFragment();
                --frames;
                out.add(end);
                ElseStatementFragment elseFrag = new ElseStatementFragment();
                ++frames;
                out.add(elseFrag);
                framesToSkip = 1;
                continue;
            }
            if (ainsnNode.getType() == 9) {
                LdcInsnNode ldc = (LdcInsnNode)ainsnNode;
                LdcFragment ldcFragment = new LdcFragment();
                ldcFragment.value = ldc.cst;
                out.add(ldcFragment);
                continue;
            }
            if (ainsnNode.getType() == 2) {
                VarInsnNode varNode = (VarInsnNode)ainsnNode;
                int operand = varNode.var;
                if (ainsnNode.getOpcode() == 54) {
                    StoreVariableFragment storeFrag = new StoreVariableFragment();
                    storeFrag.variableName = varNameMap.get(operand);
                    storeFrag.variableIndex = operand;
                    storeFrag.variableType = "int";
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 57) {
                    StoreVariableFragment storeFrag = new StoreVariableFragment();
                    storeFrag.variableName = varNameMap.get(operand);
                    storeFrag.variableIndex = operand;
                    storeFrag.variableType = "double";
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 55) {
                    StoreVariableFragment storeFrag = new StoreVariableFragment();
                    storeFrag.variableName = varNameMap.get(operand);
                    storeFrag.variableIndex = operand;
                    storeFrag.variableType = "long";
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 56) {
                    StoreVariableFragment storeFrag = new StoreVariableFragment();
                    storeFrag.variableName = varNameMap.get(operand);
                    storeFrag.variableIndex = operand;
                    storeFrag.variableType = "float";
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() == 58) {
                    StoreVariableFragment storeFrag = new StoreVariableFragment();
                    storeFrag.variableName = varNameMap.get(operand);
                    storeFrag.variableIndex = operand;
                    storeFrag.variableType = varTypeMap.get(operand);
                    out.add(storeFrag);
                    continue;
                }
                if (ainsnNode.getOpcode() != 23 && ainsnNode.getOpcode() != 22 && ainsnNode.getOpcode() != 21 && ainsnNode.getOpcode() != 24 && ainsnNode.getOpcode() != 25) continue;
                LoadVariableFragment loadFrag = new LoadVariableFragment();
                loadFrag.variableName = varNameMap.get(operand);
                loadFrag.variableIndex = operand;
                out.add(loadFrag);
                continue;
            }
            if (ainsnNode.getType() == 4) {
                FieldInsnNode fieldNode = (FieldInsnNode)ainsnNode;
                if (fieldNode.getOpcode() == 181) {
                    PutFieldFragment putFieldFrag = new PutFieldFragment();
                    putFieldFrag.fieldType = BytecodeDecoder.typesFromDesc(fieldNode.desc)[0];
                    putFieldFrag.fieldName = fieldNode.name;
                    out.add(putFieldFrag);
                    continue;
                }
                if (fieldNode.getOpcode() != 180) continue;
                GetFieldFragment getFieldFrag = new GetFieldFragment();
                getFieldFrag.fieldType = BytecodeDecoder.typesFromDesc(fieldNode.desc)[0];
                getFieldFrag.fieldName = fieldNode.name;
                out.add(getFieldFrag);
                continue;
            }
            if (ainsnNode.getType() == 1) {
                IntInsnNode intNode = (IntInsnNode)ainsnNode;
                int operand = intNode.operand;
                if (intNode.getOpcode() == 16) {
                    IntPushFragment pushFrag = new IntPushFragment();
                    pushFrag.value = operand;
                    out.add(pushFrag);
                    continue;
                }
                if (intNode.getOpcode() == 17) {
                    IntPushFragment pushFrag = new IntPushFragment();
                    pushFrag.value = operand;
                    out.add(pushFrag);
                    continue;
                }
                if (intNode.getOpcode() != 188) continue;
                NewPrimitiveArrayFragment arrayFrag = new NewPrimitiveArrayFragment();
                arrayFrag.type = Printer.TYPES[operand];
                out.add(arrayFrag);
                continue;
            }
            if (ainsnNode.getType() == 3) {
                TypeInsnNode typeNode = (TypeInsnNode)ainsnNode;
                String operand = typeNode.desc;
                if (typeNode.getOpcode() == 189) {
                    NewArrayFragment newArray = new NewArrayFragment();
                    newArray.type = operand.replace("/", ".");
                    out.add(newArray);
                    continue;
                }
                if (ainsnNode.getOpcode() == 192) {
                    CastFragment cast = new CastFragment();
                    cast.from = "java.lang.Object";
                    cast.to = operand.replace("/", ".");
                    out.add(cast);
                    continue;
                }
                if (ainsnNode.getOpcode() != 187) continue;
                NewInstanceFragment newFrag = new NewInstanceFragment();
                newFrag.type = operand.replace("/", ".");
                out.add(newFrag);
                continue;
            }
            if (ainsnNode.getType() == 13) {
                MultiANewArrayInsnNode multiArrayNode = (MultiANewArrayInsnNode)ainsnNode;
                NewMultiArrayFragment multiFrag = new NewMultiArrayFragment();
                multiFrag.type = BytecodeDecoder.typesFromDesc(multiArrayNode.desc)[0].replace("[]", "");
                multiFrag.dimensions = multiArrayNode.dims;
                out.add(multiFrag);
                continue;
            }
            if (ainsnNode.getType() == 15) {
                LineNumberNode lineNode = (LineNumberNode)ainsnNode;
                LineNumberFragment lineNumberFragment = new LineNumberFragment();
                lineNumberFragment.line = lineNode.line;
                out.add(lineNumberFragment);
                continue;
            }
            if (ainsnNode.getType() != 5) continue;
            MethodInsnNode methodNode = (MethodInsnNode)ainsnNode;
            if (methodNode.getOpcode() == 184) {
                String desc = methodNode.desc;
                String margs = desc.substring(desc.indexOf(40) + 1, desc.indexOf(41));
                String[] margsArray = BytecodeDecoder.typesFromDesc(margs);
                String n = methodNode.name;
                methodFragment = new MethodCallFragment();
                methodFragment.invokeType = MethodCallFragment.InvokeTypes.STATIC;
                methodFragment.methodName = n;
                methodFragment.methodOwner = methodNode.owner.replace("/", ".");
                methodFragment.argumentsTypes = margsArray;
                methodFragment.returnType = BytecodeDecoder.typesFromDesc(desc.substring(desc.indexOf(")") + 1))[0];
                out.add(methodFragment);
                BytecodeDecoder.addAnnotFragments(methodNode.owner, n, methodNode.desc, methodFragment);
                continue;
            }
            if (methodNode.getOpcode() == 183) {
                String desc = methodNode.desc;
                String margs = desc.substring(desc.indexOf(40) + 1, desc.indexOf(41));
                String[] margsArray = BytecodeDecoder.typesFromDesc(margs);
                String n = methodNode.name;
                methodFragment = new MethodCallFragment();
                methodFragment.invokeType = MethodCallFragment.InvokeTypes.SPECIAL;
                methodFragment.methodName = n;
                methodFragment.methodOwner = methodNode.owner.replace("/", ".");
                methodFragment.argumentsTypes = margsArray;
                methodFragment.returnType = BytecodeDecoder.typesFromDesc(desc.substring(desc.indexOf(")") + 1))[0];
                out.add(methodFragment);
                BytecodeDecoder.addAnnotFragments(methodNode.owner, n, methodNode.desc, methodFragment);
                continue;
            }
            if (methodNode.getOpcode() != 182) continue;
            String desc = methodNode.desc;
            String margs = desc.substring(desc.indexOf(40) + 1, desc.indexOf(41));
            String[] margsArray = BytecodeDecoder.typesFromDesc(margs);
            String n = methodNode.name;
            methodFragment = new MethodCallFragment();
            methodFragment.invokeType = MethodCallFragment.InvokeTypes.VIRTUAL;
            methodFragment.methodName = n;
            methodFragment.methodOwner = methodNode.owner.replace("/", ".");
            methodFragment.argumentsTypes = margsArray;
            methodFragment.returnType = BytecodeDecoder.typesFromDesc(desc.substring(desc.indexOf(")") + 1))[0];
            out.add(methodFragment);
            BytecodeDecoder.addAnnotFragments(methodNode.owner, n, methodNode.desc, methodFragment);
        }
    }

    private static String[] typesFromDesc(String desc, int startPos) {
        boolean parsingObjectClass = false;
        boolean parsingArrayClass = false;
        ArrayList<String> types = new ArrayList<String>();
        String currentObjectClass = null;
        String currentArrayClass = null;
        int dims = 1;
        for (int i = startPos; i < desc.length(); ++i) {
            char c = desc.charAt(i);
            if (!parsingObjectClass && !parsingArrayClass) {
                if (c == '[') {
                    parsingArrayClass = true;
                    currentArrayClass = "";
                    continue;
                }
                if (c == 'L') {
                    parsingObjectClass = true;
                    currentObjectClass = "";
                    continue;
                }
                if (c == 'I') {
                    types.add("int");
                    continue;
                }
                if (c == 'D') {
                    types.add("double");
                    continue;
                }
                if (c == 'B') {
                    types.add("byte");
                    continue;
                }
                if (c == 'Z') {
                    types.add("boolean");
                    continue;
                }
                if (c == 'V') {
                    types.add("void");
                    continue;
                }
                if (c == 'J') {
                    types.add("long");
                    continue;
                }
                if (c == 'C') {
                    types.add("char");
                    continue;
                }
                if (c == 'F') {
                    types.add("float");
                    continue;
                }
                if (c != 83) continue;
                types.add("short");
                continue;
            }
            if (parsingObjectClass) {
                if (c == '/') {
                    c = '.';
                } else if (c == ';') {
                    parsingObjectClass = false;
                    types.add(currentObjectClass);
                    continue;
                }
                currentObjectClass = currentObjectClass + c;
                continue;
            }
            if (!parsingArrayClass) continue;
            if (c == '[') {
                ++dims;
                continue;
            }
            if (c == '/') {
                c = '.';
            }
            if (c == 'L') continue;
            if (c == ';') {
                parsingArrayClass = false;
                String dim = "";
                for (int ii = 0; ii < dims; ++ii) {
                    dim = dim + "[]";
                }
                types.add(currentArrayClass + dim);
                dims = 1;
                continue;
            }
            currentArrayClass = currentArrayClass + c;
        }
        if (parsingObjectClass) {
            types.add(currentObjectClass);
        }
        if (parsingArrayClass) {
            String dim = "";
            for (int ii = 0; ii < dims; ++ii) {
                dim = dim + "[]";
            }
            types.add(currentArrayClass + dim);
        }
        return types.toArray(new String[0]);
    }

    private static String[] typesFromDesc(String desc) {
        return BytecodeDecoder.typesFromDesc(desc, 0);
    }

    private static void addAnnotFragments(String methodClass, String methodName, String methodDesc, CodeFragment fragment) {
        try {
            ClassReader reader = new ClassReader(BytecodeDecoder.class.getResourceAsStream("/" + methodClass.replace(".", "/") + ".class"));
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            List methodList = classNode.methods;
            for (MethodNode methodNode : methodList) {
                if (!methodNode.name.equals(methodName) || !methodNode.desc.equals(methodDesc)) continue;
                List annots = methodNode.visibleAnnotations;
                if (annots != null) {
                    for (AnnotationNode annot : annots) {
                        fragment.addChild(BytecodeDecoder.createFromNode(annot));
                        if (!DEBUG) continue;
                        System.out.println(annot.desc);
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

