/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion;

import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;

public class IndentedStringWriter
extends StringWriter {
    private int indentation = 0;
    private final String indentStr;
    private boolean writeIndentNext = false;

    public IndentedStringWriter(@NotNull String indentStr) {
        this.indentStr = indentStr;
    }

    protected String indentStr() {
        return this.indentStr.repeat(Math.max(0, this.indentation));
    }

    @Override
    public void write(int c) {
        this.write(String.valueOf((char)c));
    }

    @Override
    public void write(@NotNull String str) {
        if (str.isEmpty()) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                super.write(10);
                this.writeIndentNext = true;
                continue;
            }
            this.writeChecked(c);
        }
    }

    private void writeChecked(char c) {
        if (this.writeIndentNext) {
            super.write(this.indentStr());
            this.writeIndentNext = false;
        }
        super.write(c);
    }

    @Override
    public void write(char @NotNull [] cbuf) {
        this.write(new String(cbuf));
    }

    @Override
    public void write(@NotNull String str, int off, int len) {
        this.write(str.substring(off, off + len));
    }

    @Override
    public void write(char @NotNull [] cbuf, int off, int len) {
        this.write(new String(cbuf, off, len));
    }

    public void indent(int amount) {
        this.indentation = Math.max(this.indentation + amount, 0);
    }

    public void indent() {
        this.indent(1);
    }

    public void unindent(int amount) {
        this.indent(-amount);
    }

    public void unindent() {
        this.unindent(1);
    }

    public void newLine() {
        this.write("\n");
    }
}

